/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.storage_types;

import com.hollingsworth.arsnouveau.common.block.tile.RepositoryTile;
import com.mojang.serialization.Codec;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.utility.CreateCodecs;
import net.dadamalda.create_compatible_storage.CCSMountedStorageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class RepositoryMountedStorage
extends WrapperMountedItemStorage<Handler>
implements SyncedMountedStorage {
    public static final Codec<RepositoryMountedStorage> CODEC = CreateCodecs.ITEM_STACK_HANDLER.xmap(RepositoryMountedStorage::new, storage -> (ItemStackHandler)storage.wrapped);
    private boolean dirty;

    protected RepositoryMountedStorage(MountedItemStorageType<?> type, IItemHandler wrapped) {
        super(type, (IItemHandlerModifiable)new Handler(wrapped));
        ((Handler)this.wrapped).onChange = () -> {
            this.dirty = true;
        };
    }

    public RepositoryMountedStorage(IItemHandler handler) {
        this((MountedItemStorageType)CCSMountedStorageTypes.REPOSITORY.get(), handler);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void afterSync(Contraption contraption, BlockPos localPos) {
        BlockEntity be = (BlockEntity)contraption.presentBlockEntities.get(localPos);
        if (be instanceof RepositoryTile) {
            RepositoryTile repository = (RepositoryTile)be;
            for (int i = 0; i < 54; ++i) {
                repository.m_6836_(i, ((Handler)this.wrapped).getStackInSlot(i));
            }
        }
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof RepositoryTile) {
            RepositoryTile repository = (RepositoryTile)be;
            for (int i = 0; i < 54; ++i) {
                repository.m_6836_(i, ((Handler)this.wrapped).getStackInSlot(i));
            }
        }
    }

    @Nullable
    public static RepositoryMountedStorage fromRepository(BlockEntity be) {
        if (be instanceof RepositoryTile) {
            RepositoryMountedStorage repositoryMountedStorage;
            RepositoryTile repository = (RepositoryTile)be;
            IItemHandler handler = (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
            if (handler instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
                repositoryMountedStorage = new RepositoryMountedStorage((IItemHandler)modifiable);
            } else {
                repositoryMountedStorage = null;
            }
            return repositoryMountedStorage;
        }
        return null;
    }

    public static final class Handler
    extends ItemStackHandler {
        private Runnable onChange = () -> {};

        private Handler(IItemHandler handler) {
            super(54);
            for (int i = 0; i < 54; ++i) {
                this.setStackInSlot(i, handler.getStackInSlot(i));
            }
        }

        protected void onContentsChanged(int slot) {
            this.onChange.run();
        }
    }
}

