/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.net;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class URLDecoder {
    public static String decode(String url) {
        return URLDecoder.decode(url, StandardCharsets.UTF_8, false);
    }

    public static String decode(String source, Charset encoding) {
        return URLDecoder.decode(source, encoding, false);
    }

    public static String decodeQuery(String source) {
        return URLDecoder.decode(source, StandardCharsets.UTF_8, true);
    }

    public static String decodeQuery(String source, Charset encoding) {
        return URLDecoder.decode(source, encoding, true);
    }

    private static String decode(String source, Charset encoding, boolean decodePlus) {
        int length = source.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        block4: for (int i = 0; i < length; ++i) {
            int ch = source.charAt(i);
            switch (ch) {
                case 37: {
                    if (i + 2 < length) {
                        char hex1 = source.charAt(i + 1);
                        char hex2 = source.charAt(i + 2);
                        int u = Character.digit(hex1, 16);
                        int l = Character.digit(hex2, 16);
                        if (u == -1 || l == -1) {
                            throw new IllegalArgumentException("Invalid sequence: " + source.substring(i));
                        }
                        bos.write((char)((u << 4) + l));
                        i += 2;
                        changed = true;
                        continue block4;
                    }
                    throw new IllegalArgumentException("Invalid sequence: " + source.substring(i));
                }
                case 43: {
                    if (decodePlus) {
                        ch = 32;
                        changed = true;
                    }
                }
                default: {
                    bos.write(ch);
                }
            }
        }
        return changed ? new String(bos.toByteArray(), encoding) : source;
    }
}

