/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.http.net;

import com.hypherionmc.simplerpc.jodd.http.HttpException;
import com.hypherionmc.simplerpc.jodd.http.ProxyInfo;
import com.hypherionmc.simplerpc.jodd.http.Sockets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;

public class Socks5ProxySocketFactory
extends SocketFactory {
    private final ProxyInfo proxy;
    private final int connectionTimeout;

    public Socks5ProxySocketFactory(ProxyInfo proxy, int connectionTimeout) {
        this.proxy = proxy;
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public Socket createSocket() {
        return new Socket();
    }

    @Override
    public Socket createSocket(String host, int port) {
        return this.createSocks5ProxySocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
        return this.createSocks5ProxySocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) {
        return this.createSocks5ProxySocket(host.getHostAddress(), port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
        return this.createSocks5ProxySocket(address.getHostAddress(), port);
    }

    private Socket createSocks5ProxySocket(String host, int port) {
        Socket socket = null;
        String proxyAddress = this.proxy.getProxyAddress();
        int proxyPort = this.proxy.getProxyPort();
        String user = this.proxy.getProxyUsername();
        String passwd = this.proxy.getProxyPassword();
        try {
            socket = Sockets.connect(proxyAddress, proxyPort, this.connectionTimeout);
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            socket.setTcpNoDelay(true);
            byte[] buf = new byte[1024];
            int index = 0;
            buf[index++] = 5;
            buf[index++] = 2;
            buf[index++] = 0;
            buf[index++] = 2;
            out.write(buf, 0, index);
            this.readBytes(in, buf, 2);
            boolean check = false;
            switch (buf[1] & 0xFF) {
                case 0: {
                    check = true;
                    break;
                }
                case 2: {
                    if (user == null || passwd == null) break;
                    index = 0;
                    buf[index++] = 1;
                    buf[index++] = (byte)user.length();
                    System.arraycopy(user.getBytes(), 0, buf, index, user.length());
                    index += user.length();
                    buf[index++] = (byte)passwd.length();
                    System.arraycopy(passwd.getBytes(), 0, buf, index, passwd.length());
                    out.write(buf, 0, index += passwd.length());
                    this.readBytes(in, buf, 2);
                    if (buf[1] != 0) break;
                    check = true;
                    break;
                }
            }
            if (!check) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new HttpException((Object)ProxyInfo.ProxyType.SOCKS5, "check failed");
            }
            index = 0;
            buf[index++] = 5;
            buf[index++] = 1;
            buf[index++] = 0;
            byte[] hostb = host.getBytes();
            int len = hostb.length;
            buf[index++] = 3;
            buf[index++] = (byte)len;
            System.arraycopy(hostb, 0, buf, index, len);
            index += len;
            buf[index++] = (byte)(port >>> 8);
            buf[index++] = (byte)(port & 0xFF);
            out.write(buf, 0, index);
            this.readBytes(in, buf, 4);
            if (buf[1] != 0) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new HttpException((Object)ProxyInfo.ProxyType.SOCKS5, "proxy returned " + buf[1]);
            }
            switch (buf[3] & 0xFF) {
                case 1: {
                    this.readBytes(in, buf, 6);
                    break;
                }
                case 3: {
                    this.readBytes(in, buf, 1);
                    this.readBytes(in, buf, (buf[0] & 0xFF) + 2);
                    break;
                }
                case 4: {
                    this.readBytes(in, buf, 18);
                    break;
                }
            }
            return socket;
        }
        catch (RuntimeException rttex) {
            this.closeSocket(socket);
            throw rttex;
        }
        catch (Exception ex) {
            this.closeSocket(socket);
            throw new HttpException((Object)ProxyInfo.ProxyType.SOCKS5, ex.toString(), ex);
        }
    }

    private void readBytes(InputStream in, byte[] buf, int len) throws IOException {
        int i;
        for (int s = 0; s < len; s += i) {
            i = in.read(buf, s, len - s);
            if (i > 0) continue;
            throw new HttpException((Object)ProxyInfo.ProxyType.SOCKS5, "stream is closed");
        }
    }

    private void closeSocket(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

