/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.integrations.launchers.types;

import com.hypherionmc.simplerpc.api.utils.APIUtils;
import com.hypherionmc.simplerpc.enums.LauncherType;
import com.hypherionmc.simplerpc.integrations.launchers.Launcher;
import java.io.File;
import java.io.StringReader;
import java.util.Properties;

public final class MultiMC
implements Launcher {
    private boolean hasLoaded = false;
    private String packName = "Unknown Pack";
    private String icon = "infinity";
    private LauncherType type = LauncherType.MULTIMC;

    @Override
    public LauncherType getLauncherType() {
        return this.type;
    }

    @Override
    public void tryLoadLauncher() {
        File instanceFile = new File(new File(APIUtils.CUR_DIR).getParent(), "instance.cfg");
        File prismInstance = new File(new File(APIUtils.CUR_DIR).getParentFile().getParentFile().getParentFile(), "prismlauncher.cfg");
        if (instanceFile.exists()) {
            try {
                String packString = this.readLauncherFile(instanceFile);
                Properties properties = new Properties();
                properties.load(new StringReader(packString));
                this.packName = properties.getProperty("name", "Unknown Pack");
                this.icon = properties.getProperty("iconKey", "infinity");
                if (prismInstance.exists() || System.getProperties().containsKey("org.prismlauncher.instance.name")) {
                    this.type = LauncherType.PRISM;
                }
                this.hasLoaded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasLoaded() {
        return this.hasLoaded;
    }

    @Override
    public String getLauncherName() {
        return this.getLauncherType() == LauncherType.MULTIMC ? "MultiMC" : "Prism Launcher";
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    public String getPackIcon() {
        return this.icon;
    }
}

