console.info("[SOCIETY] handlePathBlockTags.js loaded");
const createBlockTypes = [
  "andesite",
  "granite",
  "diorite",
  "calcite",
  "tuff",
  "dripstone",
  "deepslate",
  "asurine",
  "crimsite",
  "ochrum",
  "veridium",
  "limestone",
  "scoria",
  "scorchia",
];
const createVariants = (type) => [
  `create:small_${type}_bricks`,
  `create:small_${type}_brick_wall`,
  `create:cut_${type}`,
  `create:cut_${type}_wall`,
  `create:layered_${type}`,
  `create:polished_cut_${type}`,
  `create:polished_cut_${type}_wall`,
  `create:${type}_pillar`,
  `create:cut_${type}_bricks`,
  `create:cut_${type}_brick_wall`,
];
const windsweptBlockTypes = [
  "dry_mossy_cobblestone",
  "dry_mossy_stone_brick",
  "shale",
  "polished_shale",
  "polished_shale_brick",
  "smooth_lunalite",
  "lunalite",
  "cut_lunalite",
  "cut_lunalite_brick",
  "gingerbread_brick",
  "packed_ice_brick",
  "blue_ice_brick",
  "packed_ice_brick",
  "snow_brick",
];
const basicVariants = (mod, type) => [
  `${mod}:${type}`,
  `${mod}:${type}_stair`,
  `${mod}:${type}_slab`,
  `${mod}:${type}_wall`,
];
let pathBlocks = [
  "windswept:pinecone_block",
  "windswept:pinecone_shingles",
  "windswept:pinecone_shingle_stairs",
  "windswept:pinecone_shingle_slab",
  "windswept:gingerbread_block",
  "windswept:glazed_gingerbread_block",
  "windswept:gingerbread_cookie_block",
  "windswept:icicle_block",
  "windswept:chiseled_icicle_block",
  "windswept:packed_ice_stairs",
  "windswept:packed_ice_slab",
  "windswept:chiseled_packed_ice_bricks",
  "windswept:blue_ice_stairs",
  "windswept:blue_ice_slab",
  "windswept:chiseled_blue_ice_bricks",
  "windswept:snow_stairs",
  "windswept:snow_slab",
  "botania:yellow_pavement",
  "botania:red_pavement",
  "botania:green_pavement",
  "botania:shimmerrock",
  "botania:livingrock",
  "botania:polished_livingrock",
  "botania:livingrock_bricks",
  "botania:livingrock_slate",
  "botania:chiseled_livingrock_bricks",
  "botania:livingwood_log",
  "botania:cracked_livingrock_bricks",
  "botania:metamorphic_mountain_bricks",
  "botania:metamorphic_mountain_cobblestone",
  "botania:chiseled_metamorphic_mountain_bricks",
  "botania:metamorphic_fungal_stone",
  "botania:metamorphic_fungal_bricks",
  "botania:metamorphic_fungal_cobblestone",
  "botania:chiseled_metamorphic_fungal_bricks",
  "botania:black_pavement",
  "botania:metamorphic_swamp_stone",
  "botania:chiseled_metamorphic_plains_bricks",
  "botania:metamorphic_plains_cobblestone",
  "botania:metamorphic_plains_bricks",
  "botania:metamorphic_plains_stone",
  "botania:metamorphic_forest_cobblestone",
  "botania:chiseled_metamorphic_forest_bricks",
  "botania:metamorphic_forest_bricks",
  "botania:metamorphic_forest_stone",
  "botania:metamorphic_mountain_stone",
  "botania:metamorphic_swamp_bricks",
  "botania:metamorphic_swamp_cobblestone",
  "botania:chiseled_metamorphic_swamp_bricks",
  "botania:metamorphic_desert_stone",
  "botania:metamorphic_desert_cobblestone",
  "botania:chiseled_metamorphic_desert_bricks",
  "botania:metamorphic_desert_bricks",
  "botania:metamorphic_taiga_stone",
  "botania:metamorphic_taiga_bricks",
  "botania:metamorphic_taiga_cobblestone",
  "botania:chiseled_metamorphic_taiga_bricks",
  "botania:metamorphic_mesa_stone",
  "botania:metamorphic_mesa_bricks",
  "botania:metamorphic_mesa_cobblestone",
  "botania:chiseled_metamorphic_mesa_bricks",
  "botania:white_pavement_stairs",
  "botania:white_pavement",
  "botania:blue_pavement",
  "vinery:dirt_path_slab",
  "atmospheric:ivory_travertine",
  "atmospheric:chiseled_ivory_travertine",
  "atmospheric:cut_ivory_travertine",
  "atmospheric:peach_travertine",
  "atmospheric:chiseled_peach_travertine",
  "atmospheric:cut_peach_travertine",
  "atmospheric:persimmon_travertine",
  "atmospheric:chiseled_persimmon_travertine",
  "atmospheric:cut_persimmon_travertine",
  "atmospheric:saffron_travertine",
  "atmospheric:chiseled_saffron_travertine",
  "atmospheric:cut_saffron_travertine",
  "atmospheric:polished_dolerite",
  "atmospheric:cut_arid_sandstone",
  "atmospheric:smooth_arid_sandstone",
  "atmospheric:chiseled_red_arid_sandstone",
  "atmospheric:cut_red_arid_sandstone",
  "farmersdelight:tatami",
  "atmospheric:crustose_path",
  "atmospheric:arid_sandstone",
  "atmospheric:chiseled_arid_sandstone",
  "atmospheric:red_arid_sandstone",
  "atmospheric:smooth_red_arid_sandstone",
  "quark:iron_plate",
  "quark:iron_pillar",
  "quark:bamboo_mat_carpet",
  "quark:bamboo_mat",
  "quark:sandstone_bricks",
  "supplementaries:blackstone_tile",
  "supplementaries:gravel_bricks",
  "supplementaries:stone_tile",
  "supplementaries:ash_bricks",
  "vintagedelight:smooth_salt_block",
  "quark:duskbound_block",
  "betterarcheology:cracked_mud_bricks",
  "vintagedelight:mixed_salt_bricks",
  "quark:smooth_soul_sandstone",
  "autumnity:chiseled_snail_shell_bricks",
  "quark:chiseled_soul_sandstone",
  "quark:dusky_myalite",
  "quark:soul_sandstone",
  "quark:duskbound_lantern",
  "quark:midori_pillar",
  "vintagedelight:salt_bricks",
  "quark:cut_soul_sandstone",
  "create:rose_quartz_tiles",
  "supplementaries:checker_block",
  "quark:mossy_cobblestone_bricks",
  "create:small_rose_quartz_tiles",
  "quark:soul_sandstone_bricks",
  "quark:midori_block",
  "quark:rusty_iron_plate",
  "autumnity:snail_shell_block",
  "autumnity:snail_shell_bricks",
  "create:rose_quartz_block",
  "twigs:gravel_bricks",
  "autumnity:snail_shell_tiles",
  "quark:red_sandstone_bricks",
  "supplementaries:fine_wood",
  "quark:cobblestone_bricks",
  "quark:cobblestone_bricks_stairs",
  "quark:cobblestone_bricks_slab",
  "copycats:copycat_board",
  "copycats:copycat_box",
  "copycats:copycat_catwalk",
  "copycats:copycat_stairs",
  "copycats:copycat_slab",
  "create:copycat_step",
  "copycats:copycat_block",
  "minecraft:quartz_block",
  "clayworks:terracotta_bricks",
  "clayworks:lime_terracotta_bricks",
  "clayworks:green_terracotta_bricks",
  "clayworks:cyan_terracotta_bricks",
  "clayworks:light_blue_terracotta_bricks",
  "clayworks:blue_terracotta_bricks",
  "clayworks:purple_terracotta_bricks",
  "clayworks:magenta_terracotta_bricks",
  "clayworks:pink_terracotta_bricks",
  "minecraft:brown_terracotta",
  "minecraft:gray_terracotta",
  "minecraft:polished_basalt",
  "minecraft:basalt",
  "minecraft:smooth_basalt",
  "minecraft:white_terracotta",
  "minecraft:light_gray_terracotta",
  "minecraft:terracotta",
  "minecraft:blue_terracotta",
  "minecraft:light_blue_terracotta",
  "minecraft:cyan_terracotta",
  "minecraft:green_terracotta",
  "minecraft:lime_terracotta",
  "minecraft:yellow_terracotta",
  "minecraft:orange_terracotta",
  "minecraft:red_terracotta",
  "minecraft:pink_terracotta",
  "minecraft:magenta_terracotta",
  "minecraft:purple_terracotta",
  "clayworks:yellow_terracotta_bricks",
  "clayworks:orange_terracotta_bricks",
  "clayworks:red_terracotta_bricks",
  "clayworks:brown_terracotta_bricks",
  "clayworks:black_terracotta_bricks",
  "clayworks:gray_terracotta_bricks",
  "clayworks:light_gray_terracotta_bricks",
  "clayworks:white_terracotta_bricks",
  "minecraft:deepslate_tile_slab",
  "minecraft:deepslate_tiles",
  "minecraft:deepslate_tile_stairs",
  "minecraft:polished_deepslate",
  "minecraft:polished_deepslate_stairs",
  "minecraft:polished_deepslate_slab",
  "minecraft:cobbled_deepslate",
  "minecraft:deepslate",
  "meadow:mossy_cobbled_limestone",
  "meadow:mossy_cobbled_limestone_stairs",
  "meadow:mossy_cobbled_limestone_slab",
  "meadow:limestone",
  "meadow:limestone_stairs",
  "meadow:limestone_slab",
  "meadow:mossy_limestone_bricks",
  "meadow:mossy_limestone_brick_stairs",
  "meadow:mossy_limestone_brick_slab",
  "meadow:cracked_limestone_bricks",
  "meadow:polished_limestone_bricks",
  "meadow:cobbled_limestone",
  "meadow:cobbled_limestone_stairs",
  "meadow:cobbled_limestone_slab",
  "meadow:chiseled_limestone_bricks",
  "meadow:limestone_bricks",
  "meadow:limestone_brick_stairs",
  "meadow:limestone_brick_slab",
  "trials:polished_tuff",
  "trials:polished_tuff_stairs",
  "trials:chiseled_tuff",
  "trials:tuff_bricks",
  "trials:tuff_brick_stairs",
  "trials:tuff_brick_slab",
  "trials:polished_tuff_stairs",
  "trials:polished_tuff_slab",
  "trials:chiseled_tuff_bricks",
  "twigs:chiseled_smooth_basalt_bricks",
  "twigs:weeping_polished_blackstone_bricks",
  "twigs:smooth_basalt_bricks",
  "twigs:twisting_polished_blackstone_bricks",
  "twigs:cut_amethyst",
  "twigs:polished_amethyst",
  "twigs:smooth_stone_bricks",
  "twigs:rocky_dirt",
  "twigs:cobblestone_bricks",
  "twigs:rhyolite",
  "twigs:polished_rhyolite",
  "twigs:polished_rhyolite_bricks",
  "twigs:cracked_polished_rhyolite_bricks",
  "twigs:bloodstone",
  "twigs:polished_bloodstone",
  "twigs:silt",
  "twigs:cracked_silt_bricks",
  "twigs:silt_bricks",
  "twigs:chiseled_silt_bricks",
  "twigs:mixed_silt_bricks",
  "twigs:packed_silt",
  "twigs:silt_shingles",
  "twigs:polished_basalt_bricks",
  "twigs:gravel_bricks",
];

ServerEvents.tags("block", (e) => {
  createBlockTypes.forEach((type) => {
    pathBlocks.push(createVariants(type));
  });
  windsweptBlockTypes.forEach((type) => {
    pathBlocks.push(basicVariants("windswept", type));
  });
  pathBlocks.forEach((block) => {
    e.add("via_romana:path_block", block);
  });

  e.add("via_romana:path_block", "#minecraft:stairs");
  e.add("via_romana:path_block", "#minecraft:slabs");
  e.add("via_romana:path_block", "#minecraft:logs");
  e.add("via_romana:path_block", "#minecraft:combination_step_sound_blocks");
  e.add("via_romana:path_block", "#minecraft:planks");
  e.add("via_romana:path_block", "#railways:locometal");
  e.add("via_romana:path_block", "#decorative_blocks:beams");
  e.add("via_romana:path_block", "#twigs:packed_silt");
});
