/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc.forge;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModLootModifiers {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"moonlight");
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> ADD_ITEM_GLM = LOOT_MODIFIERS.register("add_item", AddItemModifier.CODEC);
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> REPLACE_ITEM_GLM = LOOT_MODIFIERS.register("replace_item", ReplaceItemModifier.CODEC);
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> ADD_TABLE = LOOT_MODIFIERS.register("add_loot_table", AddTableModifier.CODEC);

    public static void register() {
        LOOT_MODIFIERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static class AddItemModifier
    extends LootModifier {
        public static final Supplier<Codec<AddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ItemStack.f_41582_.fieldOf("item").forGetter(m -> m.addedItemStack)).apply((Applicative)inst, AddItemModifier::new)));
        private final ItemStack addedItemStack;

        public AddItemModifier(LootItemCondition[] conditionsIn, ItemStack addedItemStack) {
            super(conditionsIn);
            this.addedItemStack = addedItemStack;
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ItemStack addedStack = this.addedItemStack.m_41777_();
            if (addedStack.m_41613_() < addedStack.m_41741_()) {
                generatedLoot.add((Object)addedStack);
            } else {
                ItemStack subStack;
                for (int i = addedStack.m_41613_(); i > 0; i -= subStack.m_41613_()) {
                    subStack = addedStack.m_41777_();
                    subStack.m_41764_(Math.min(addedStack.m_41741_(), i));
                    generatedLoot.add((Object)subStack);
                }
            }
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    public static class ReplaceItemModifier
    extends LootModifier {
        public static final Supplier<Codec<ReplaceItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ItemStack.f_41582_.fieldOf("item").forGetter(m -> m.itemStack)).apply((Applicative)inst, ReplaceItemModifier::new)));
        private final ItemStack itemStack;

        public ReplaceItemModifier(LootItemCondition[] conditionsIn, ItemStack addedItemStack) {
            super(conditionsIn);
            this.itemStack = addedItemStack;
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            if (!generatedLoot.isEmpty()) {
                generatedLoot.set(0, (Object)this.itemStack.m_41777_());
            }
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    public static class AddTableModifier
    extends LootModifier {
        public static final Supplier<Codec<AddTableModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddTableModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ResourceLocation.f_135803_.fieldOf("loot_table").forGetter(m -> m.injectTableId)).apply((Applicative)inst, AddTableModifier::new)));
        private final ResourceLocation injectTableId;

        public AddTableModifier(LootItemCondition[] conditionsIn, ResourceLocation addedItemStack) {
            super(conditionsIn);
            this.injectTableId = addedItemStack;
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            LootTable lootTable = context.m_78952_().m_7654_().m_278653_().m_278676_(this.injectTableId);
            lootTable.m_79148_(context, arg_0 -> generatedLoot.add(arg_0));
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

