/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math.colors;

import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.minecraft.util.Mth;

public class RGBColor
extends BaseColor<RGBColor> {
    public RGBColor(int value) {
        this((float)RGBColor.getR(value) / 255.0f, (float)RGBColor.getG(value) / 255.0f, (float)RGBColor.getB(value) / 255.0f, (float)RGBColor.getA(value) / 255.0f);
    }

    public RGBColor(float r, float g, float b, float a) {
        super(Mth.m_14036_((float)r, (float)0.0f, (float)1.0f), Mth.m_14036_((float)g, (float)0.0f, (float)1.0f), Mth.m_14036_((float)b, (float)0.0f, (float)1.0f), Mth.m_14036_((float)a, (float)0.0f, (float)1.0f));
    }

    public static int getA(int abgr) {
        return abgr >> 24 & 0xFF;
    }

    public static int getR(int abgr) {
        return abgr & 0xFF;
    }

    public static int getG(int agbgr) {
        return agbgr >> 8 & 0xFF;
    }

    public static int getB(int agbgr) {
        return agbgr >> 16 & 0xFF;
    }

    public static int combine(int alpha, int blue, int green, int red) {
        return (alpha & 0xFF) << 24 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | red & 0xFF;
    }

    public String toString() {
        return String.format("R: %s, G: %s, B %s", (int)(255.0f * this.red()), (int)(255.0f * this.green()), (int)(255.0f * this.blue()));
    }

    public float red() {
        return this.v0;
    }

    public float green() {
        return this.v1;
    }

    public float blue() {
        return this.v2;
    }

    public float alpha() {
        return this.v3;
    }

    public RGBColor withRed(float red) {
        return new RGBColor(red, this.green(), this.blue(), this.alpha());
    }

    public RGBColor withGreen(float green) {
        return new RGBColor(this.red(), green, this.blue(), this.alpha());
    }

    public RGBColor withBlue(float blue) {
        return new RGBColor(this.red(), this.green(), blue, this.alpha());
    }

    public RGBColor withAlpha(float alpha) {
        return new RGBColor(this.red(), this.green(), this.blue(), alpha);
    }

    @Override
    public RGBColor asRGB() {
        return this;
    }

    public static RGBColor averageColors(RGBColor ... colors) {
        float size = colors.length;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 0.0f;
        for (RGBColor c : colors) {
            r += c.red();
            g += c.green();
            b += c.blue();
            a += c.alpha();
        }
        return new RGBColor(r / size, g / size, b / size, a / size);
    }

    @Override
    public RGBColor multiply(float red, float green, float blue, float alpha) {
        return new RGBColor(Mth.m_14036_((float)(red * this.red()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(green * this.green()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(blue * this.blue()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(alpha * this.alpha()), (float)0.0f, (float)1.0f));
    }

    @Deprecated(forRemoval=true)
    public RGBColor multiply(RGBColor color, float hue, float chroma, float luminance, float alpha) {
        return this.multiply(hue, chroma, luminance, alpha);
    }

    @Override
    public RGBColor mixWith(RGBColor color, float bias) {
        float i = 1.0f - bias;
        float r = this.red() * i + color.red() * bias;
        float g = this.green() * i + color.green() * bias;
        float b = this.blue() * i + color.blue() * bias;
        float a = this.alpha() * i + color.alpha() * bias;
        return new RGBColor(r, g, b, a);
    }

    @Override
    public RGBColor fromRGB(RGBColor rgb) {
        return this;
    }

    public int toInt() {
        return RGBColor.combine((int)(this.alpha() * 255.0f), (int)(this.blue() * 255.0f), (int)(this.green() * 255.0f), (int)(this.red() * 255.0f));
    }
}

