/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ninni.etcetera.Etcetera;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;

public class EtceteraProcessResourceManager
extends SimpleJsonResourceReloadListener {
    public static final String FOLDER_KEY = "processes";
    private static final Gson GSON = new GsonBuilder().create();
    private final String id;
    private Data data;

    public EtceteraProcessResourceManager(String id) {
        super(GSON, FOLDER_KEY);
        this.id = id;
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        try {
            JsonElement jsonElement = prepared.get(new ResourceLocation("etcetera", this.id));
            if (!(jsonElement instanceof JsonObject)) {
                throw new RuntimeException("Was not a json object");
            }
            JsonObject jsonObject = (JsonObject)jsonElement;
            this.data = (Data)Data.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().orElseThrow();
        }
        catch (Exception exception) {
            Etcetera.LOGGER.error("Couldn't read list {}", (Object)this.id, (Object)exception);
        }
    }

    public Map<Block, Block> getMap() {
        return this.data == null ? Collections.emptyMap() : this.data.map();
    }

    public record Data(Map<Block, Block> map) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)BuiltInRegistries.f_256975_.m_194605_(), (Codec)BuiltInRegistries.f_256975_.m_194605_()).fieldOf("entries").forGetter(Data::map)).apply((Applicative)instance, Data::new));
    }
}

