/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.client.model;

import com.google.common.collect.ImmutableList;
import com.ninni.etcetera.entity.TurtleRaftEntity;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TurtleRaftModel
extends ListModel<TurtleRaftEntity> {
    private static final String LEFT_PADDLE = "left_paddle";
    private static final String RIGHT_PADDLE = "right_paddle";
    private static final String BOTTOM = "bottom";
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ModelPart bottom;

    public TurtleRaftModel(ModelPart root) {
        this.leftPaddle = root.m_171324_(LEFT_PADDLE);
        this.rightPaddle = root.m_171324_(RIGHT_PADDLE);
        this.bottom = root.m_171324_(BOTTOM);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.bottom, (Object)this.leftPaddle, (Object)this.rightPaddle);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -4.0f, -7.0f, 14.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
        modelPartData.m_171599_(LEFT_PADDLE, CubeListBuilder.m_171558_().m_171514_(62, 0).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-3.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        modelPartData.m_171599_(RIGHT_PADDLE, CubeListBuilder.m_171558_().m_171514_(62, 20).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-3.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)128, (int)64);
    }

    public void setupAnim(TurtleRaftEntity raft, float f, float g, float h, float i, float j) {
        TurtleRaftModel.setPaddleAngle(raft, 0, this.leftPaddle, f);
        TurtleRaftModel.setPaddleAngle(raft, 1, this.rightPaddle, f);
    }

    private static void setPaddleAngle(Boat entity, int sigma, ModelPart part, float angle) {
        float f = entity.m_38315_(sigma, angle);
        part.f_104203_ = Mth.m_144920_((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.m_14031_((float)(-f)) + 1.0f) / 2.0f));
        part.f_104204_ = Mth.m_144920_((float)-0.7853982f, (float)0.7853982f, (float)((Mth.m_14031_((float)(-f + 1.0f)) + 1.0f) / 2.0f));
        if (sigma == 1) {
            part.f_104204_ = (float)Math.PI - part.f_104204_;
        }
    }
}

