/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ninni.etcetera.block.SquidLampBlock;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WallSquidLampBlock
extends SquidLampBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)WallSquidLampBlock.m_49796_((double)5.0, (double)5.0, (double)7.0, (double)11.0, (double)11.0, (double)16.0), (Object)Direction.SOUTH, (Object)WallSquidLampBlock.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)9.0), (Object)Direction.WEST, (Object)WallSquidLampBlock.m_49796_((double)7.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (Object)Direction.EAST, (Object)WallSquidLampBlock.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)11.0)));

    public WallSquidLampBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public String m_7705_() {
        return this.m_5456_().m_5524_();
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return WallSquidLampBlock.getBoundingShape(state);
    }

    public static VoxelShape getBoundingShape(BlockState state) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)FACING));
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60783_((BlockGetter)world, pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()), (Direction)state.m_61143_((Property)FACING));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        for (Direction direction : ctx.m_6232_()) {
            BlockPos blockPos;
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_())) continue;
            Level worldAccess = ctx.m_43725_();
            boolean bl = worldAccess.m_6425_(blockPos = ctx.m_8083_()).m_76152_() == Fluids.f_76193_;
            return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
        }
        return null;
    }

    @Override
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double x = (double)pos.m_123341_() + random.m_188500_();
        double y = (double)pos.m_123342_() + 0.7;
        double z = (double)pos.m_123343_() + random.m_188500_();
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_175827_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState p_60543_, LevelAccessor world, BlockPos pos, BlockPos p_60546_) {
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{FACING}));
    }
}

