/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.functions;

import net.minecraft.util.Mth;
import org.joml.Math;

public class MathUtil {
    public static final float[] PACK_FACTOR = new float[]{127.0f, -127.0f};

    public static int packSafe(float x, float y, float z, float factor) {
        float scalar = Math.invsqrt((float)Math.fma((float)x, (float)x, (float)Math.fma((float)y, (float)y, (float)(z * z))));
        int normX = (int)((x *= scalar) * factor) & 0xFF;
        int normY = (int)((y *= scalar) * factor) & 0xFF;
        int normZ = (int)((z *= scalar) * factor) & 0xFF;
        return normZ << 16 | normY << 8 | normX;
    }

    public static int packSafe(float x, float y, float z) {
        float scalar = Math.invsqrt((float)Math.fma((float)x, (float)x, (float)Math.fma((float)y, (float)y, (float)(z * z))));
        int normX = (int)((x *= scalar) * 127.0f) & 0xFF;
        int normY = (int)((y *= scalar) * 127.0f) & 0xFF;
        int normZ = (int)((z *= scalar) * 127.0f) & 0xFF;
        return normZ << 16 | normY << 8 | normX;
    }

    public static int packUnsafe(float x, float y, float z, float factor) {
        int normX = (int)(x * factor) & 0xFF;
        int normY = (int)(y * factor) & 0xFF;
        int normZ = (int)(z * factor) & 0xFF;
        return normZ << 16 | normY << 8 | normX;
    }

    public static int packUnsafe(float x, float y, float z) {
        int normX = (int)(x * 127.0f) & 0xFF;
        int normY = (int)(y * 127.0f) & 0xFF;
        int normZ = (int)(z * 127.0f) & 0xFF;
        return normZ << 16 | normY << 8 | normX;
    }

    public static int normal2Int(float x, float y, float z) {
        float scalar = Math.invsqrt((float)Math.fma((float)x, (float)x, (float)Math.fma((float)y, (float)y, (float)(z * z))));
        return MathUtil.packUnsafe(x * scalar, y * scalar, z * scalar);
    }

    public static int normal2IntClamp(float x, float y, float z) {
        return MathUtil.packUnsafe(Mth.m_14036_((float)x, (float)-1.0f, (float)1.0f), Mth.m_14036_((float)y, (float)-1.0f, (float)1.0f), Mth.m_14036_((float)z, (float)-1.0f, (float)1.0f));
    }

    public static boolean cullBackFace(byte viewX, byte viewY, byte viewZ, int normal) {
        byte normalX = (byte)normal;
        byte normalY = (byte)(normal >> 8);
        byte normalZ = (byte)(normal >> 16);
        return viewX * normalX + viewY * normalY + viewZ * normalZ > 768;
    }

    public static long compose(int lo, int hi) {
        return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
    }
}

