/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.functions;

import com.moepus.flerovium.Flerovium;
import com.moepus.flerovium.functions.MathUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.jellysquid.mods.sodium.client.render.immediate.model.ModelCuboid;
import me.jellysquid.mods.sodium.client.render.immediate.model.ModelPartData;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.NormalAttribute;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.minecraft.client.model.geom.ModelPart;
import org.apache.commons.lang3.ArrayUtils;
import org.embeddedt.embeddium.render.matrix_stack.CachingPoseStack;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class FastEntityRenderer {
    private static final int NUM_CUBE_VERTICES = 8;
    private static final int NUM_CUBE_FACES = 6;
    private static final int NUM_FACE_VERTICES = 4;
    private static final byte FACE_NEG_Y = 0;
    private static final byte FACE_POS_Y = 1;
    private static final byte FACE_NEG_Z = 2;
    private static final byte FACE_POS_Z = 3;
    private static final byte FACE_NEG_X = 4;
    private static final byte FACE_POS_X = 5;
    private static final byte VERTEX_X1_Y1_Z1 = 0;
    private static final byte VERTEX_X2_Y1_Z1 = 1;
    private static final byte VERTEX_X2_Y2_Z1 = 2;
    private static final byte VERTEX_X1_Y2_Z1 = 3;
    private static final byte VERTEX_X1_Y1_Z2 = 4;
    private static final byte VERTEX_X2_Y1_Z2 = 5;
    private static final byte VERTEX_X2_Y2_Z2 = 6;
    private static final byte VERTEX_X1_Y2_Z2 = 7;
    private static final long SCRATCH_BUFFER = MemoryUtil.nmemAlignedAlloc((long)64L, (long)864L);
    private static final MemoryStack STACK = MemoryStack.create();
    private static final Vertex[] CUBE_CORNERS = new Vertex[8];
    private static final byte[][] CUBE_VERTICES = new byte[][]{{5, 4, 0, 1}, {2, 3, 7, 6}, {1, 0, 3, 2}, {4, 5, 6, 7}, {0, 4, 7, 3}, {5, 1, 2, 6}};
    private static final Vertex[][] VERTEX_POSITIONS = new Vertex[6][4];
    private static final long[][] VERTEX_TEXTURES = new long[6][4];
    private static final int[] CUBE_NORMALS = new int[6];
    private static int FACE;

    public static void render(PoseStack matrixStack, VertexBufferWriter writer, ModelPart part, int light, int overlay, int color) {
        ModelPartData accessor = ModelPartData.from((ModelPart)part);
        if (!accessor.isVisible()) {
            return;
        }
        Object[] cuboids = accessor.getCuboids();
        Object[] children = accessor.getChildren();
        if (ArrayUtils.isEmpty((Object[])cuboids) && ArrayUtils.isEmpty((Object[])children)) {
            return;
        }
        ((CachingPoseStack)matrixStack).embeddium$setCachingEnabled(true);
        matrixStack.m_85836_();
        part.m_104299_(matrixStack);
        if (!accessor.isHidden()) {
            FastEntityRenderer.renderCuboids(matrixStack.m_85850_(), writer, (ModelCuboid[])cuboids, light, overlay, color);
        }
        FastEntityRenderer.renderChildren(matrixStack, writer, light, overlay, color, (ModelPart[])children);
        matrixStack.m_85849_();
        ((CachingPoseStack)matrixStack).embeddium$setCachingEnabled(false);
    }

    private static void renderCuboids(PoseStack.Pose matrices, VertexBufferWriter writer, ModelCuboid[] cuboids, int light, int overlay, int color) {
        FastEntityRenderer.prepareNormals(matrices);
        for (ModelCuboid cuboid : cuboids) {
            FastEntityRenderer.prepareVertices(matrices, cuboid, color);
            int vertexCount = FastEntityRenderer.emitQuads(cuboid, overlay, light);
            try (MemoryStack stack = MemoryStack.stackPush();){
                writer.push(stack, SCRATCH_BUFFER, vertexCount, ModelVertex.FORMAT);
            }
        }
    }

    private static void renderChildren(PoseStack matrices, VertexBufferWriter writer, int light, int overlay, int color, ModelPart[] children) {
        for (ModelPart part : children) {
            FastEntityRenderer.render(matrices, writer, part, light, overlay, color);
        }
    }

    public static void renderCuboidFast(PoseStack.Pose matrices, VertexBufferWriter writer, ModelCuboid cuboid, int light, int overlay, int color) {
        FastEntityRenderer.prepareVertices(matrices, cuboid, color);
        int vertexCount = FastEntityRenderer.emitQuads(cuboid, overlay, light);
        STACK.push();
        writer.push(STACK, SCRATCH_BUFFER, vertexCount, ModelVertex.FORMAT);
        STACK.pop();
    }

    private static int emitQuads(ModelCuboid cuboid, int overlay, int light) {
        long packedOverlayLight = MathUtil.compose(overlay, light);
        int vertexCount = 0;
        long ptr = SCRATCH_BUFFER;
        if (!cuboid.mirror) {
            for (int quadIndex = 0; quadIndex < 6; ++quadIndex) {
                if (!cuboid.shouldDrawFace(quadIndex) || (FACE & 1 << quadIndex) == 0) continue;
                int normal = CUBE_NORMALS[quadIndex];
                FastEntityRenderer.emitVertex(ptr, VERTEX_POSITIONS[quadIndex][0], VERTEX_TEXTURES[quadIndex][0], packedOverlayLight, normal);
                FastEntityRenderer.emitVertex(ptr += 36L, VERTEX_POSITIONS[quadIndex][1], VERTEX_TEXTURES[quadIndex][1], packedOverlayLight, normal);
                FastEntityRenderer.emitVertex(ptr += 36L, VERTEX_POSITIONS[quadIndex][2], VERTEX_TEXTURES[quadIndex][2], packedOverlayLight, normal);
                FastEntityRenderer.emitVertex(ptr += 36L, VERTEX_POSITIONS[quadIndex][3], VERTEX_TEXTURES[quadIndex][3], packedOverlayLight, normal);
                ptr += 36L;
                vertexCount += 4;
            }
        } else {
            for (int quadIndex = 0; quadIndex < 6; ++quadIndex) {
                if (!cuboid.shouldDrawFace(quadIndex) || (FACE & 1 << quadIndex) == 0) continue;
                int normal = CUBE_NORMALS[quadIndex];
                FastEntityRenderer.emitVertex(ptr, VERTEX_POSITIONS[quadIndex][3], VERTEX_TEXTURES[quadIndex][3], packedOverlayLight, normal);
                FastEntityRenderer.emitVertex(ptr += 36L, VERTEX_POSITIONS[quadIndex][2], VERTEX_TEXTURES[quadIndex][2], packedOverlayLight, normal);
                FastEntityRenderer.emitVertex(ptr += 36L, VERTEX_POSITIONS[quadIndex][1], VERTEX_TEXTURES[quadIndex][1], packedOverlayLight, normal);
                FastEntityRenderer.emitVertex(ptr += 36L, VERTEX_POSITIONS[quadIndex][0], VERTEX_TEXTURES[quadIndex][0], packedOverlayLight, normal);
                ptr += 36L;
                vertexCount += 4;
            }
        }
        return vertexCount;
    }

    private static void emitVertex(long ptr, Vertex vertex, long uv, long packedOverlayLight, int normal) {
        MemoryUtil.memPutLong((long)(ptr + 0L), (long)vertex.xy);
        MemoryUtil.memPutLong((long)(ptr + 8L), (long)vertex.zw);
        MemoryUtil.memPutLong((long)(ptr + 16L), (long)uv);
        MemoryUtil.memPutLong((long)(ptr + 24L), (long)packedOverlayLight);
        NormalAttribute.set((long)(ptr + 32L), (int)normal);
    }

    private static void prepareVertices(PoseStack.Pose matrices, ModelCuboid cuboid, int color) {
        Matrix4f pose = matrices.m_252922_();
        float p1x = MatrixHelper.transformPositionX((Matrix4f)pose, (float)cuboid.x1, (float)cuboid.y1, (float)cuboid.z1);
        float p1y = MatrixHelper.transformPositionY((Matrix4f)pose, (float)cuboid.x1, (float)cuboid.y1, (float)cuboid.z1);
        float p1z = MatrixHelper.transformPositionZ((Matrix4f)pose, (float)cuboid.x1, (float)cuboid.y1, (float)cuboid.z1);
        CUBE_CORNERS[0].set(p1x, p1y, p1z, color);
        float lx = cuboid.x2 - cuboid.x1;
        float ly = cuboid.y2 - cuboid.y1;
        float lz = cuboid.z2 - cuboid.z1;
        float vxx = pose.m00() * lx;
        float vxy = pose.m01() * lx;
        float vxz = pose.m02() * lx;
        float vyx = pose.m10() * ly;
        float vyy = pose.m11() * ly;
        float vyz = pose.m12() * ly;
        float vzx = pose.m20() * lz;
        float vzy = pose.m21() * lz;
        float vzz = pose.m22() * lz;
        float p2x = p1x + vxx;
        float p2y = p1y + vxy;
        float p2z = p1z + vxz;
        CUBE_CORNERS[1].set(p2x, p2y, p2z, color);
        float p3x = p2x + vyx;
        float p3y = p2y + vyy;
        float p3z = p2z + vyz;
        CUBE_CORNERS[2].set(p3x, p3y, p3z, color);
        float p4x = p1x + vyx;
        float p4y = p1y + vyy;
        float p4z = p1z + vyz;
        CUBE_CORNERS[3].set(p4x, p4y, p4z, color);
        float p5x = p1x + vzx;
        float p5y = p1y + vzy;
        float p5z = p1z + vzz;
        CUBE_CORNERS[4].set(p5x, p5y, p5z, color);
        float p6x = p2x + vzx;
        float p6y = p2y + vzy;
        float p6z = p2z + vzz;
        CUBE_CORNERS[5].set(p6x, p6y, p6z, color);
        float p7x = p3x + vzx;
        float p7y = p3y + vzy;
        float p7z = p3z + vzz;
        CUBE_CORNERS[6].set(p7x, p7y, p7z, color);
        float p8x = p4x + vzx;
        float p8y = p4y + vzy;
        float p8z = p4z + vzz;
        CUBE_CORNERS[7].set(p8x, p8y, p8z, color);
        FastEntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[0], cuboid.u1, cuboid.v0, cuboid.u2, cuboid.v1);
        FastEntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[1], cuboid.u2, cuboid.v1, cuboid.u3, cuboid.v0);
        FastEntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[2], cuboid.u1, cuboid.v1, cuboid.u2, cuboid.v2);
        FastEntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[3], cuboid.u4, cuboid.v1, cuboid.u5, cuboid.v2);
        FastEntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[4], cuboid.u0, cuboid.v1, cuboid.u1, cuboid.v2);
        FastEntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[5], cuboid.u2, cuboid.v1, cuboid.u4, cuboid.v2);
        FACE = -1;
        if (!Flerovium.config.entityBackFaceCulling) {
            return;
        }
        if (matrices.m_252922_().m32() <= -16.0f && RenderSystem.modelViewMatrix.m32() == 0.0f && ly != 0.0f) {
            Matrix3f normal = matrices.m_252943_();
            float posX = p1x + p8x;
            float posY = p1y + p8y;
            float posZ = p1z + p8z;
            if (posX * normal.m00 + posY * normal.m01 + posZ * normal.m02 < 0.0f) {
                FACE &= ~(1 << (lx > 0.0f ? 4 : 5));
            }
            if ((posX = p2x + p7x) * normal.m00 + (posY = p2y + p7y) * normal.m01 + (posZ = p2z + p7z) * normal.m02 > 0.0f) {
                FACE &= ~(1 << (lx < 0.0f ? 4 : 5));
            }
            if ((posX = p1x + p3x) * normal.m20 + (posY = p1y + p3y) * normal.m21 + (posZ = p1z + p3z) * normal.m22 < 0.0f) {
                FACE &= 0xFFFFFFFB;
            }
            if ((posX = p5x + p7x) * normal.m20 + (posY = p5y + p7y) * normal.m21 + (posZ = p5z + p7z) * normal.m22 > 0.0f) {
                FACE &= 0xFFFFFFF7;
            }
            if ((posX = p1x + p6x) * normal.m10 + (posY = p1y + p6y) * normal.m11 + (posZ = p1z + p6z) * normal.m12 < 0.0f) {
                FACE &= 0xFFFFFFFE;
            }
            if ((posX = p4x + p7x) * normal.m10 + (posY = p4y + p7y) * normal.m11 + (posZ = p4z + p7z) * normal.m12 > 0.0f) {
                FACE &= 0xFFFFFFFD;
            }
        }
    }

    public static void prepareNormals(PoseStack.Pose matrices) {
        Matrix3f normal = matrices.m_252943_();
        FastEntityRenderer.CUBE_NORMALS[0] = MathUtil.normal2IntClamp(-normal.m10, -normal.m11, -normal.m12);
        FastEntityRenderer.CUBE_NORMALS[1] = MathUtil.normal2IntClamp(normal.m10, normal.m11, normal.m12);
        FastEntityRenderer.CUBE_NORMALS[2] = MathUtil.normal2IntClamp(-normal.m20, -normal.m21, -normal.m22);
        FastEntityRenderer.CUBE_NORMALS[3] = MathUtil.normal2IntClamp(normal.m20, normal.m21, normal.m22);
        FastEntityRenderer.CUBE_NORMALS[4] = MathUtil.normal2IntClamp(-normal.m00, -normal.m01, -normal.m02);
        FastEntityRenderer.CUBE_NORMALS[5] = MathUtil.normal2IntClamp(normal.m00, normal.m01, normal.m02);
    }

    private static void buildVertexTexCoord(long[] uvs, float u1, float v1, float u2, float v2) {
        uvs[0] = MathUtil.compose(Float.floatToRawIntBits(u2), Float.floatToRawIntBits(v1));
        uvs[1] = MathUtil.compose(Float.floatToRawIntBits(u1), Float.floatToRawIntBits(v1));
        uvs[2] = MathUtil.compose(Float.floatToRawIntBits(u1), Float.floatToRawIntBits(v2));
        uvs[3] = MathUtil.compose(Float.floatToRawIntBits(u2), Float.floatToRawIntBits(v2));
    }

    static {
        for (int cornerIndex = 0; cornerIndex < 8; ++cornerIndex) {
            FastEntityRenderer.CUBE_CORNERS[cornerIndex] = new Vertex();
        }
        for (int quadIndex = 0; quadIndex < 6; ++quadIndex) {
            for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                FastEntityRenderer.VERTEX_POSITIONS[quadIndex][vertexIndex] = CUBE_CORNERS[CUBE_VERTICES[quadIndex][vertexIndex]];
            }
        }
    }

    static class Vertex {
        public long xy;
        public long zw;

        Vertex() {
        }

        public void set(float x, float y, float z, int color) {
            this.xy = MathUtil.compose(Float.floatToRawIntBits(x), Float.floatToRawIntBits(y));
            this.zw = MathUtil.compose(Float.floatToRawIntBits(z), color);
        }
    }
}

