/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.liopyu.entityjs.builders.modification.ModifyEntityBuilder;
import net.liopyu.entityjs.client.utils.VertexModifier;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRendererMixin {
    @Unique
    private Object entityJs$builder;
    private EntityModel model;
    @Unique
    private EntityRenderDispatcher entityRenderDispatcher = (EntityRenderDispatcher)this;

    @Inject(method={"render"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    public <E extends Entity> void render(E entity, double pX, double pY, double pZ, float pRotationYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, CallbackInfo ci) {
        ModifyEntityBuilder builder;
        Object object;
        if (entity instanceof LivingEntity) {
            return;
        }
        EntityType entityType = entity.m_6095_();
        if (this.entityJs$builder == null) {
            EntityModificationEventJS eventJS = EntityModificationEventJS.getOrCreate(entityType, entity);
            this.entityJs$builder = eventJS.getBuilder();
        }
        if ((object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            builder = (ModifyEntityBuilder)((Object)object);
            if (builder.setTextureLocation == null && builder.setRenderType == null) {
                return;
            }
        }
        if ((object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ContextUtils.RendererModelContext context;
            builder = (ModifyEntityBuilder)((Object)object);
            if (builder.setTextureLocation != null && builder.setRenderType != null) {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: You may not set both setRenderType and setTextureLocation at the same time for entity: " + entity.m_6095_() + ".");
                return;
            }
            if (builder.setTextureLocation != null) {
                context = new ContextUtils.RendererModelContext(entity, this.entityRenderDispatcher.m_114382_(entity), this.model);
                try {
                    Object obj = builder.setTextureLocation.apply(context);
                    Object resourcelocation = EntityJSHelperClass.convertObjectToDesired(obj, "resourcelocation");
                    if (resourcelocation != null) {
                        ResourceLocation textureLocation = (ResourceLocation)resourcelocation;
                        this.entityjs$render(this.entityRenderDispatcher, entity, pX, pY, pZ, pRotationYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight, ci, textureLocation);
                        return;
                    }
                    if (obj != null) {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid value in setTextureLocation field from entity: " + entity.m_6095_() + ". Value: " + resourcelocation + ". Must be a resource location");
                    }
                    return;
                }
                catch (Throwable e) {
                    EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in modifyEntity method setTextureLocation from entity: " + entity.m_6095_() + ". ", e);
                }
            }
            if (builder.setRenderType != null) {
                context = new ContextUtils.RendererModelContext(entity, this.entityRenderDispatcher.m_114382_(entity), this.model);
                try {
                    Object obj = builder.setRenderType.apply(context);
                    RenderType returnValue = EntityJSHelperClass.convertToRenderType(obj, null);
                    if (returnValue != null) {
                        this.entityjs$render(this.entityRenderDispatcher, entity, pX, pY, pZ, pRotationYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight, ci, returnValue);
                        return;
                    }
                    if (obj != null) {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid value in setRenderType field from entity: " + entity.m_6095_() + ". Must return either a resource location or a RenderType. Return null for the default texture logic.");
                    }
                }
                catch (Throwable e) {
                    EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in modifyEntity method setRenderType from entity: " + entity.m_6095_() + ". ", e);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private <E extends Entity> void entityjs$render(EntityRenderDispatcher entityRenderDispatcher, E pEntity, double pX, double pY, double pZ, float pRotationYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, CallbackInfo ci, Object locationOrRenderType) {
        EntityRenderer entityrenderer = entityRenderDispatcher.m_114382_(pEntity);
        try {
            double d1;
            float f;
            Vec3 vec3 = entityrenderer.m_7860_(pEntity, pPartialTicks);
            double d2 = pX + vec3.m_7096_();
            double d3 = pY + vec3.m_7098_();
            double d0 = pZ + vec3.m_7094_();
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(d2, d3, d0);
            MultiBufferSource interceptedBuffer = pBuffer;
            if (locationOrRenderType instanceof RenderType) {
                RenderType type = (RenderType)locationOrRenderType;
                interceptedBuffer = renderType -> new VertexModifier(pBuffer.m_6299_(type));
            } else if (locationOrRenderType instanceof ResourceLocation) {
                ResourceLocation location = (ResourceLocation)locationOrRenderType;
                interceptedBuffer = renderType -> new VertexModifier(pBuffer.m_6299_(RenderType.m_110452_((ResourceLocation)location)));
            }
            entityrenderer.m_7392_(pEntity, pRotationYaw, pPartialTicks, pPoseStack, interceptedBuffer, pPackedLight);
            if (pEntity.m_6051_()) {
                entityRenderDispatcher.m_114453_(pPoseStack, pBuffer, pEntity);
            }
            pPoseStack.m_85837_(-vec3.m_7096_(), -vec3.m_7098_(), -vec3.m_7094_());
            if (((Boolean)entityRenderDispatcher.f_114360_.m_231818_().m_231551_()).booleanValue() && entityRenderDispatcher.f_114368_ && entityrenderer.f_114477_ > 0.0f && !pEntity.m_20145_() && (f = (float)((1.0 - (d1 = entityRenderDispatcher.m_114378_(pEntity.m_20185_(), pEntity.m_20186_(), pEntity.m_20189_())) / 256.0) * (double)entityrenderer.f_114478_)) > 0.0f) {
                EntityRenderDispatcher.m_114457_((PoseStack)pPoseStack, (MultiBufferSource)pBuffer, pEntity, (float)f, (float)pPartialTicks, (LevelReader)entityRenderDispatcher.f_114366_, (float)Math.min(entityrenderer.f_114477_, 32.0f));
            }
            if (entityRenderDispatcher.f_114369_ && !pEntity.m_20145_() && !Minecraft.m_91087_().m_91299_()) {
                EntityRenderDispatcher.m_114441_((PoseStack)pPoseStack, (VertexConsumer)pBuffer.m_6299_(RenderType.m_110504_()), pEntity, (float)pPartialTicks);
            }
            pPoseStack.m_85849_();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering entity in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
            pEntity.m_7976_(crashreportcategory);
            CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
            crashreportcategory1.m_128159_("Assigned renderer", (Object)entityrenderer);
            crashreportcategory1.m_128159_("Location", (Object)CrashReportCategory.m_178937_((LevelHeightAccessor)entityRenderDispatcher.f_114366_, (double)pX, (double)pY, (double)pZ));
            crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(pRotationYaw));
            crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(pPartialTicks));
            throw new ReportedException(crashreport);
        }
        ci.cancel();
    }
}

