/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.living.model;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.liopyu.entityjs.util.ContextUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public class ItemArmorJSBuilder<T extends LivingEntity> {
    public Function<T, Boolean> addArmorItemLayer = null;
    public final T entity;
    public Map<String, EquipmentSlot> armorBoneToSlotMap = new HashMap<String, EquipmentSlot>();
    public transient Consumer<ContextUtils.RenderBoneContext<T>> renderBone;
    public transient Consumer<ContextUtils.VanillaArmorRenderContext<T>> vanillaArmorRenderConsumer;

    public ItemArmorJSBuilder(T entity) {
        this.entity = entity;
    }

    @Info(value="A Consumer controlling custom rendering logic for a vanilla armor piece on a model bone.\n\nExample usage:\n```javascript\narmorBuilder.renderArmor(context => {\n    let {\n        poseStack,\n        bone,\n        slot,\n        armorStack,\n        modelPart,\n        entity,\n        bufferSource,\n        partialTick,\n        packedLight,\n        packedOverlay\n    } = context\n\n    if (bone.name === \"left_leg\") {\n        poseStack.translate(0.1, 0.0, 0.0)\n        poseStack.scale(1.2, 1.2, 1.2)\n    }\n})\n```\n")
    public ItemArmorJSBuilder<T> renderArmor(Consumer<ContextUtils.VanillaArmorRenderContext<T>> consumer) {
        this.vanillaArmorRenderConsumer = consumer;
        return this;
    }

    @Info(value="A Consumer determining custom rendering logic for an armor model bone.\n\nThis runs during the armor rendering pass, allowing you to manipulate specific armor bones \u2014\nfor example, applying dynamic offsets or transformations per bone before rendering.\n\nExample usage:\n```javascript\narmorBuilder.renderBone(context => {\n    let {\n        poseStack,\n        bone,\n        entity,\n        partialTick,\n        bufferSource,\n        packedLight,\n        packedOverlay\n    } = context\n\n    if (bone.name == \"helmet\") {\n        poseStack.translate(0, 0.05, 0)\n        poseStack.scale(1.1, 1.1, 1.1)\n    }\n})\n```\n")
    public ItemArmorJSBuilder<T> renderBone(Consumer<ContextUtils.RenderBoneContext<T>> renderBone) {
        this.renderBone = renderBone;
        return this;
    }

    public ItemArmorJSBuilder<T> setLeftShoulderArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.CHEST);
        return this;
    }

    public ItemArmorJSBuilder<T> setRightShoulderArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.CHEST);
        return this;
    }

    public ItemArmorJSBuilder<T> setLeftLegArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.LEGS);
        return this;
    }

    public ItemArmorJSBuilder<T> setRightLegArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.LEGS);
        return this;
    }

    public ItemArmorJSBuilder<T> setLeftFootArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.FEET);
        return this;
    }

    public ItemArmorJSBuilder<T> setRightFootArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.FEET);
        return this;
    }

    public ItemArmorJSBuilder<T> withArmorItemLayer(Function<T, Boolean> predicate) {
        this.addArmorItemLayer = predicate;
        return this;
    }

    public ItemArmorJSBuilder<T> withArmorBoneMapping(Map<String, EquipmentSlot> mapping) {
        this.armorBoneToSlotMap = mapping;
        return this;
    }

    public ItemArmorJSBuilder<T> setHeadArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.HEAD);
        return this;
    }

    public ItemArmorJSBuilder<T> setChestArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.CHEST);
        return this;
    }

    public ItemArmorJSBuilder<T> setLegArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.LEGS);
        return this;
    }

    public ItemArmorJSBuilder<T> setFeetArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.FEET);
        return this;
    }

    public ItemArmorJSBuilder<T> setMainHandArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.MAINHAND);
        return this;
    }

    public ItemArmorJSBuilder<T> setOffhandArmorBone(Function<T, String> boneName) {
        this.armorBoneToSlotMap.put(boneName.apply(this.entity), EquipmentSlot.OFFHAND);
        return this;
    }
}

