/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.builders.living.vanilla;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Consumer;
import net.liopyu.entityjs.builders.living.entityjs.MobBuilder;
import net.liopyu.entityjs.entities.living.vanilla.SlimeEntityJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Slime;

public class SlimeJSBuilder
extends MobBuilder<SlimeEntityJS> {
    public transient Boolean defaultGoals = true;
    public transient ParticleOptions setParticleType;
    public transient Consumer<ContextUtils.LivingEntityContext> dealDamage;
    public transient SoundEvent setSquishSound;

    public SlimeJSBuilder(ResourceLocation i) {
        super(i);
    }

    @Info(value="@param setSquishSound Sets the squish sound\n\nExample usage:\n```javascript\nbuilder.setSquishSound(\"block.azalea.hit\");\n```\n")
    public SlimeJSBuilder setSquishSound(SoundEvent sound) {
        this.setSquishSound = sound;
        return this;
    }

    @Info(value="@param setParticleType Sets the particles emitted off the slime\nDefaults to slime particles\n\nExample usage:\n```javascript\nbuilder.setParticleType(\"crit\");\n```\n")
    public SlimeJSBuilder setParticleType(ParticleType<?> type) {
        this.setParticleType = (ParticleOptions)type;
        return this;
    }

    @Info(value="@param dealDamage Overrides the way the slime deals damage\n\nExample usage:\n```javascript\nbuilder.dealDamage(ctx => {\n\tconst { entity, target } = ctx\n\t// Determine how the slime deals damage\n});\n```\n")
    public SlimeJSBuilder dealDamage(Consumer<ContextUtils.LivingEntityContext> dealDamage) {
        this.dealDamage = dealDamage;
        return this;
    }

    @Info(value="@param defaultGoals Sets whether the mob should inherit it's goals from it's superclass\nDefaults to true.\n\nExample usage:\n```javascript\nbuilder.defaultGoals(false);\n```\n")
    public SlimeJSBuilder defaultGoals(boolean defaultGoals) {
        this.defaultGoals = defaultGoals;
        return this;
    }

    @Override
    public EntityType.EntityFactory<SlimeEntityJS> factory() {
        return (type, level) -> new SlimeEntityJS(this, (EntityType<? extends Slime>)type, level);
    }

    @Override
    public AttributeSupplier.Builder getAttributeBuilder() {
        return SlimeEntityJS.m_21552_().m_22266_(Attributes.f_22281_);
    }
}

