/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.durability_module;

import io.redspace.ironsrpgtweaks.config.ConfigHelper;
import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.durability_module.DeathDurabilityMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DurabilityServerEvents {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if ((Double)ServerConfigs.DURABILITY_LOST_ON_DEATH.get() == 0.0 && (Integer)ServerConfigs.ADDITIONAL_DURABILITY_LOST_ON_DEATH.get() == 0 || !((Boolean)ServerConfigs.DURABILITY_MODULE_ENABLED.get()).booleanValue() || serverPlayer.f_8941_.m_9295_()) {
                return;
            }
            DeathDurabilityMode mode = (DeathDurabilityMode)((Object)ServerConfigs.DURABILITY_DEATH_MODE.get());
            Inventory inventory = serverPlayer.m_150109_();
            if (mode.shouldDamageTools()) {
                DurabilityServerEvents.damageItems(DurabilityServerEvents.getHotbarItems(inventory), serverPlayer);
            }
            if (mode.shouldDamageArmor()) {
                DurabilityServerEvents.damageItems(DurabilityServerEvents.getArmorItems(inventory), serverPlayer);
            }
        }
    }

    private static void damageItems(List<ItemStack> items, ServerPlayer serverPlayer) {
        for (ItemStack itemstack : items) {
            if (!itemstack.m_41763_() || !ConfigHelper.Durability.shouldTakeDeathDamage(itemstack)) continue;
            int i = itemstack.getEnchantmentLevel(Enchantments.f_44986_) + 1;
            int damageAmount = (int)((double)itemstack.m_41776_() * (Double)ServerConfigs.DURABILITY_LOST_ON_DEATH.get()) + (Integer)ServerConfigs.ADDITIONAL_DURABILITY_LOST_ON_DEATH.get();
            itemstack.m_41721_(itemstack.m_41773_() + (damageAmount /= i));
            Component component = itemstack.m_41611_();
            if (!(component instanceof MutableComponent)) continue;
            MutableComponent itemName = (MutableComponent)component;
            if (itemstack.m_41773_() < itemstack.m_41776_()) {
                if (itemstack.m_41776_() - itemstack.m_41773_() < damageAmount) {
                    serverPlayer.m_213846_((Component)Component.m_237110_((String)"ui.irons_rpg_tweaks.item_damaged_critical", (Object[])new Object[]{itemName.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131155_(Boolean.valueOf(false))), damageAmount}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131155_(Boolean.valueOf(true))));
                } else {
                    serverPlayer.m_213846_((Component)Component.m_237110_((String)"ui.irons_rpg_tweaks.item_damaged", (Object[])new Object[]{itemName.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))), damageAmount}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
                }
            }
            itemstack.m_41622_(0, (LivingEntity)serverPlayer, player -> {
                player.m_213846_((Component)Component.m_237110_((String)"ui.irons_rpg_tweaks.item_broken", (Object[])new Object[]{itemName.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131155_(Boolean.valueOf(false)))}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131155_(Boolean.valueOf(true))));
                Item patt4171$temp = itemstack.m_41720_();
                if (patt4171$temp instanceof ArmorItem) {
                    ArmorItem armorItem = (ArmorItem)patt4171$temp;
                    player.m_21166_(armorItem.m_40402_());
                } else {
                    player.m_21166_(EquipmentSlot.MAINHAND);
                }
            });
        }
    }

    private static List<ItemStack> getHotbarItems(Inventory inventory) {
        ArrayList<ItemStack> hotbarItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_() && i < 9; ++i) {
            ItemStack item = inventory.m_8020_(i);
            if (item.m_41619_()) continue;
            hotbarItems.add(item);
        }
        if (!((ItemStack)inventory.f_35976_.get(0)).m_41619_()) {
            hotbarItems.add((ItemStack)inventory.f_35976_.get(0));
        }
        return hotbarItems;
    }

    private static List<ItemStack> getArmorItems(Inventory inventory) {
        ArrayList<ItemStack> armorItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.f_35975_.size(); ++i) {
            ItemStack item = (ItemStack)inventory.f_35975_.get(i);
            if (item.m_41619_()) continue;
            armorItems.add(item);
        }
        return armorItems;
    }

    private static String printInventory(Inventory inventory) {
        Object str = "";
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            str = (String)str + inventory.m_8020_(i).m_41786_().getString() + ",";
        }
        return str;
    }
}

