/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.damage_module;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.damage_module.IRpgLivingEntityExtension;
import io.redspace.ironsrpgtweaks.damage_module.PlayerDamageMode;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DamageServerEvents {
    @SubscribeEvent
    public static void onRecieveDamage(LivingAttackEvent event) {
        boolean ignoreDamage;
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!DamageServerEvents.shouldProcess(source, entity)) {
            return;
        }
        IRpgLivingEntityExtension livingExtension = (IRpgLivingEntityExtension)entity;
        int lastActuallyHurtTimestamp = livingExtension.rpg_tweaks$getHurtTracker().getOrDefault((Object)source.m_269150_(), -1);
        int lastDamageRequestTimestamp = livingExtension.rpg_tweaks$getRequestDamageTracker().getOrDefault((Object)source.m_269150_(), -1);
        int currentTick = entity.f_19797_;
        boolean bl = ignoreDamage = event.getEntity().f_19802_ > 0 || currentTick - lastDamageRequestTimestamp <= 1 && currentTick - lastActuallyHurtTimestamp < 10;
        if (ignoreDamage) {
            event.setCanceled(true);
        }
        livingExtension.rpg_tweaks$updateLastRequest((Holder<DamageType>)source.m_269150_(), currentTick);
    }

    @SubscribeEvent
    public static void onTakeDamage(LivingDamageEvent event) {
        if (DamageServerEvents.shouldProcess(event.getSource(), event.getEntity())) {
            event.getEntity().f_19802_ = (Integer)ServerConfigs.IFRAME_COUNT.get();
            IRpgLivingEntityExtension entityExtension = (IRpgLivingEntityExtension)event.getEntity();
            entityExtension.rpg_tweaks$updateLastHurt((Holder<DamageType>)event.getSource().m_269150_(), event.getEntity().f_19797_);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        Level level = event.getEntity().m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (!(event.getEntity() instanceof FakePlayer) && (double)event.getEntity().m_36403_(0.0f) < (Double)ServerConfigs.MINIMUM_ATTACK_STRENGTH.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void modifyKnockback(LivingKnockBackEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            event.setStrength((float)((double)event.getStrength() * (Double)ServerConfigs.KNOCKBACK_MODIFIER.get()));
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue() && event.getEntity().f_19797_ % 600 == 0) {
            ((IRpgLivingEntityExtension)event.getEntity()).rpg_tweaks$garbageCollect(event.getEntity().f_19797_);
        }
    }

    private static boolean shouldProcess(DamageSource source, LivingEntity entityBeingAttacked) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            return !(entityBeingAttacked instanceof Player) || ServerConfigs.PLAYER_DAMAGE_MODE.get() == PlayerDamageMode.ALL || ServerConfigs.PLAYER_DAMAGE_MODE.get() == PlayerDamageMode.ONLY_LIVING && source.m_7640_() instanceof LivingEntity;
        }
        return false;
    }
}

