/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.block.StemBlock;
import net.satisfy.vinery.core.block.entity.LatticeBlockEntity;
import net.satisfy.vinery.core.item.GrapeBushSeedItem;
import net.satisfy.vinery.core.util.GeneralUtil;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatticeBlock
extends StemBlock
implements EntityBlock {
    public static final BooleanProperty SUPPORT = BooleanProperty.m_61465_((String)"support");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<GeneralUtil.LineConnectingType> TYPE = GeneralUtil.LINE_CONNECTING_TYPE;
    protected static final VoxelShape EAST = LatticeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST = LatticeBlock.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = LatticeBlock.m_49796_((double)0.0, (double)0.0, (double)0.01, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape NORTH = LatticeBlock.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FLOOR = LatticeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final SoundEvent BREAK_SOUND_EVENT = SoundEvents.f_12455_;
    private static final SoundEvent PLACE_SOUND_EVENT = SoundEvents.f_12456_;

    public LatticeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SUPPORT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_(TYPE, (Comparable)((Object)GeneralUtil.LineConnectingType.NONE)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clickedFacingFace;
        Level level = context.m_43725_();
        Direction facing = context.m_8125_().m_122424_();
        BlockPos clickedPos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        BlockPos clickedFacingPos = clickedPos.m_121945_(clickedFace.m_122424_());
        BlockState clickedFacingState = level.m_8055_(clickedFacingPos);
        if (context.m_43723_() != null && !context.m_43723_().m_6047_() && clickedFacingState.m_60734_() instanceof LatticeBlock && (clickedFacingFace = (Direction)clickedFacingState.m_61143_((Property)FACING)) != clickedFace && clickedFacingFace.m_122424_() != clickedFace) {
            facing = clickedFacingFace;
        }
        boolean bottom = clickedFace == Direction.DOWN || clickedFace == Direction.UP;
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(bottom));
        if (!bottom) {
            state = this.getConnection(state, (LevelAccessor)level, clickedPos);
        }
        return state;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (Boolean.TRUE.equals(state.m_61143_((Property)BOTTOM))) {
            return FLOOR;
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            default -> NORTH;
        };
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        LatticeBlockEntity lattice;
        BlockEntity be;
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        int age = (Integer)state.m_61143_((Property)AGE);
        if (stack.m_41720_() instanceof AxeItem) {
            BlockState newState = (BlockState)state.m_61124_((Property)SUPPORT, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)SUPPORT) == false));
            BlockState updateState = this.getConnection(newState, (LevelAccessor)world, pos);
            world.m_7731_(pos, updateState, 3);
            return InteractionResult.SUCCESS;
        }
        Item updateState = stack.m_41720_();
        if (updateState instanceof GrapeBushSeedItem) {
            GrapeBushSeedItem seedItem = (GrapeBushSeedItem)updateState;
            GrapeType type = seedItem.getType();
            if (age == 0 && type.isLattice()) {
                BlockState newState = this.withAge(state, 1, type);
                world.m_7731_(pos, newState, 3);
                BlockEntity be2 = world.m_7702_(pos);
                if (be2 instanceof LatticeBlockEntity) {
                    LatticeBlockEntity lattice2 = (LatticeBlockEntity)be2;
                    lattice2.setAge(1);
                    lattice2.setGrapeType(type);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                world.m_5594_(null, pos, PLACE_SOUND_EVENT, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if (age > 0 && stack.m_41720_() == Items.f_42574_) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            if (age > 2) {
                this.dropGrapes(world, state, pos, hit.m_82434_());
            }
            this.dropGrapeSeeds(world, state, pos, hit.m_82434_());
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 3);
            be = world.m_7702_(pos);
            if (be instanceof LatticeBlockEntity) {
                lattice = (LatticeBlockEntity)be;
                lattice.setAge(0);
            }
            world.m_5594_(player, pos, BREAK_SOUND_EVENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (age > 2) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            this.dropGrapes(world, state, pos, hit.m_82434_());
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
            be = world.m_7702_(pos);
            if (be instanceof LatticeBlockEntity) {
                lattice = (LatticeBlockEntity)be;
                lattice.setAge(1);
            }
            world.m_5594_(player, pos, BREAK_SOUND_EVENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        Random rand = new Random();
        if (rand.nextInt(100) >= 98 || this.isMature(state)) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        GrapeType type = (GrapeType)state.m_61143_((Property)GRAPE);
        BlockState newState = this.withAge(state, age + 1, type);
        world.m_7731_(pos, newState, 2);
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof LatticeBlockEntity) {
            LatticeBlockEntity lattice = (LatticeBlockEntity)be;
            lattice.setAge(age + 1);
            lattice.setGrapeType(type);
        }
        super.m_213898_(state, world, pos, random);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            if ((Integer)state.m_61143_((Property)AGE) > 0) {
                this.dropGrapeSeeds((Level)world, state, pos, null);
            }
            if ((Integer)state.m_61143_((Property)AGE) > 2) {
                this.dropGrapes((Level)world, state, pos, null);
            }
            world.m_46961_(pos, true);
        }
    }

    public boolean m_6724_(BlockState state) {
        int age = (Integer)state.m_61143_((Property)AGE);
        return !this.isMature(state) && age > 0 && age < 4;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return this.getConnection(state, world, pos);
    }

    @Override
    public boolean m_7370_(LevelReader levelReader, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMature(state) && (Integer)state.m_61143_((Property)AGE) > 0;
    }

    public BlockState getConnection(BlockState state, LevelAccessor level, BlockPos currentPos) {
        boolean sideR;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean bottom = (Boolean)state.m_61143_((Property)BOTTOM);
        BlockState stateL = level.m_8055_(currentPos.m_121945_(facing.m_122427_()));
        BlockState stateR = level.m_8055_(currentPos.m_121945_(facing.m_122428_()));
        boolean sideL = stateL.m_60734_() instanceof LatticeBlock && stateL.m_61143_((Property)FACING) == facing && (Boolean)stateL.m_61143_((Property)BOTTOM) == bottom;
        boolean bl = sideR = stateR.m_60734_() instanceof LatticeBlock && stateR.m_61143_((Property)FACING) == facing && (Boolean)stateR.m_61143_((Property)BOTTOM) == bottom;
        GeneralUtil.LineConnectingType type = sideL && sideR ? GeneralUtil.LineConnectingType.MIDDLE : (sideR ? GeneralUtil.LineConnectingType.LEFT : (sideL ? GeneralUtil.LineConnectingType.RIGHT : GeneralUtil.LineConnectingType.NONE));
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, TYPE, SUPPORT, BOTTOM});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new LatticeBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }
}

