/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppleLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    public static final BooleanProperty CAN_GROW_APPLES = BooleanProperty.m_61465_((String)"can_grow_apples");
    public static final BooleanProperty HAS_APPLES = BooleanProperty.m_61465_((String)"has_apples");
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)3);

    public AppleLeavesBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)CAN_GROW_APPLES, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_APPLES, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)HAS_APPLES)).booleanValue() && (Integer)state.m_61143_((Property)AGE) == 3) {
            if (!world.m_5776_()) {
                int dropCount = world.m_213780_().m_188499_() ? world.m_213780_().m_216339_(1, 4) : 1;
                ItemStack dropStack = new ItemStack((ItemLike)Items.f_42410_, dropCount);
                AppleLeavesBlock.m_152435_((Level)world, (BlockPos)pos, (Direction)hit.m_82434_(), (ItemStack)dropStack);
                world.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)HAS_APPLES, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public boolean m_6724_(BlockState state) {
        boolean can = (Boolean)state.m_61143_((Property)CAN_GROW_APPLES);
        boolean has = (Boolean)state.m_61143_((Property)HAS_APPLES);
        int age = (Integer)state.m_61143_((Property)AGE);
        return can && !has && age < 2 || has && age == 2 || super.m_6724_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean canGrowApples = ctx.m_43725_().f_46441_.m_188501_() < 0.3f;
        return this.updateDistance((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CAN_GROW_APPLES, (Comparable)Boolean.valueOf(canGrowApples))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)HAS_APPLES, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(false)), (LevelAccessor)ctx.m_43725_(), ctx.m_8083_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CAN_GROW_APPLES, HAS_APPLES, AGE});
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213898_(state, world, pos, random);
        boolean can = (Boolean)state.m_61143_((Property)CAN_GROW_APPLES);
        boolean has = (Boolean)state.m_61143_((Property)HAS_APPLES);
        int age = (Integer)state.m_61143_((Property)AGE);
        double chance = PlatformHelper.getAppleGrowthChance();
        if (can && !has && age < 2 && random.m_188500_() < chance && this.canGrowPlace((LevelReader)world, pos)) {
            BlockState newState = age == 0 ? (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)) : (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2))).m_61124_((Property)HAS_APPLES, (Comparable)Boolean.valueOf(true));
            world.m_7731_(pos, newState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)newState));
        } else if (has && age == 2 && random.m_188500_() < chance && this.canGrowPlace((LevelReader)world, pos)) {
            BlockState newState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(3));
            world.m_7731_(pos, newState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)newState));
        }
    }

    private boolean canGrowPlace(LevelReader world, BlockPos pos) {
        return world.m_45524_(pos, 0) > 9;
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos pos, BlockState state, boolean isClient) {
        int age = (Integer)state.m_61143_((Property)AGE);
        boolean has = (Boolean)state.m_61143_((Property)HAS_APPLES);
        return age < 2 && !has || age == 2 && has;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState s = state;
        if (!((Boolean)s.m_61143_((Property)CAN_GROW_APPLES)).booleanValue()) {
            s = (BlockState)s.m_61124_((Property)CAN_GROW_APPLES, (Comparable)Boolean.valueOf(true));
        }
        int age = (Integer)s.m_61143_((Property)AGE);
        boolean has = (Boolean)s.m_61143_((Property)HAS_APPLES);
        if (!has && age < 2 && this.canGrowPlace((LevelReader)level, pos)) {
            BlockState newState = age == 0 ? (BlockState)s.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)) : (BlockState)((BlockState)s.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2))).m_61124_((Property)HAS_APPLES, (Comparable)Boolean.valueOf(true));
            level.m_7731_(pos, newState, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)newState));
        } else if (has && age == 2 && this.canGrowPlace((LevelReader)level, pos)) {
            BlockState newState = (BlockState)s.m_61124_((Property)AGE, (Comparable)Integer.valueOf(3));
            level.m_7731_(pos, newState, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)newState));
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateDistance(state, world, pos);
    }

    private static int getDistanceAt(BlockState neighborState) {
        return neighborState.m_60734_() instanceof LeavesBlock ? (Integer)neighborState.m_61143_((Property)f_54418_) : (neighborState.m_204336_(BlockTags.f_13106_) ? 0 : 7);
    }

    private BlockState updateDistance(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction dir;
        BlockState neighbor;
        int minDistance = 7;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n && (minDistance = Math.min(minDistance, AppleLeavesBlock.getDistanceAt(neighbor = world.m_8055_(pos.m_121945_(dir = directionArray[i]))) + 1)) != 1; ++i) {
        }
        return (BlockState)state.m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(minDistance));
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }
}

