/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.album;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.render.PhotographRenderProperties;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PhotographSlotButton
extends ImageButton {
    protected final Rect2i exposureArea;
    protected final Button.OnPress onRightButtonPress;
    protected final Supplier<ItemStack> photograph;
    protected final boolean isEditable;
    protected boolean hasPhotograph;

    public PhotographSlotButton(Rect2i exposureArea, int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffTex, ResourceLocation resourceLocation, int textureWidth, int textureHeight, Button.OnPress onLeftButtonPress, Button.OnPress onRightButtonPress, Supplier<ItemStack> photographGetter, boolean isEditable) {
        super(x, y, width, height, xTexStart, yTexStart, yDiffTex, resourceLocation, textureWidth, textureHeight, onLeftButtonPress, (Component)Component.m_237115_((String)"item.exposure.photograph"));
        this.exposureArea = exposureArea;
        this.onRightButtonPress = onRightButtonPress;
        this.photograph = photographGetter;
        this.isEditable = isEditable;
    }

    public ItemStack getPhotograph() {
        return this.photograph.get();
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemStack photograph = this.getPhotograph();
        if (photograph.m_41720_() instanceof PhotographItem) {
            this.hasPhotograph = true;
            PhotographRenderProperties renderProperties = PhotographRenderProperties.get(photograph);
            this.m_280322_(guiGraphics, renderProperties.getAlbumPaperTexture(), this.m_252754_(), this.m_252907_(), 0, 0, 0, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
            guiGraphics.m_280168_().m_85836_();
            float scale = (float)this.exposureArea.m_110090_() / (float)ExposureClient.getExposureRenderer().getSize();
            guiGraphics.m_280168_().m_252880_((float)this.exposureArea.m_110085_(), (float)this.exposureArea.m_110086_(), 1.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            PhotographRenderer.render(photograph, false, false, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0, 255, 255, 255, 255);
            bufferSource.m_109911_();
            guiGraphics.m_280168_().m_85849_();
            if (renderProperties.hasAlbumPaperOverlayTexture()) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
                this.m_280322_(guiGraphics, renderProperties.getAlbumPaperOverlayTexture(), this.m_252754_(), this.m_252907_(), 0, 0, 0, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
                guiGraphics.m_280168_().m_85849_();
            }
        } else {
            this.hasPhotograph = false;
        }
        int xTex = this.f_94224_ + (this.hasPhotograph ? this.m_5711_() : 0);
        this.m_280322_(guiGraphics, this.f_94223_, this.m_252754_(), this.m_252907_(), xTex, this.f_94225_, this.f_94226_, this.f_93618_, this.f_93619_, this.f_94227_, this.f_94228_);
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isEditable && !this.hasPhotograph) {
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.exposure.album.add_photograph"), mouseX, mouseY);
            return;
        }
        ItemStack photograph = this.getPhotograph();
        if (photograph.m_41619_()) {
            return;
        }
        List itemTooltip = Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)photograph);
        itemTooltip.add(Component.m_237115_((String)"gui.exposure.album.left_click_or_scroll_up_to_view"));
        if (this.isEditable) {
            itemTooltip.add(Component.m_237115_((String)"gui.exposure.album.right_click_to_remove"));
        }
        if (this.m_93696_()) {
            guiGraphics.m_280547_(Minecraft.m_91087_().f_91062_, Lists.transform((List)itemTooltip, Component::m_7532_), this.m_262860_(), mouseX, mouseY);
        } else {
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, itemTooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!(this.f_93623_ && this.f_93624_ && this.m_93680_(mouseX, mouseY))) {
            return false;
        }
        if (button == 0) {
            this.f_93717_.m_93750_((Button)this);
        } else if (button == 1) {
            this.onRightButtonPress.m_93750_((Button)this);
        } else {
            return false;
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0 && this.m_93680_(mouseX, mouseY) && this.hasPhotograph) {
            this.f_93717_.m_93750_((Button)this);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_93623_ && this.f_93624_ && Screen.m_96638_() && CommonInputs.m_278691_((int)keyCode)) {
            this.onRightButtonPress.m_93750_((Button)this);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

