/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.album;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.gui.screen.album.AlbumPhotographScreen;
import io.github.mortuusars.exposure.gui.screen.album.AlbumSigningScreen;
import io.github.mortuusars.exposure.gui.screen.album.PhotographSlotButton;
import io.github.mortuusars.exposure.gui.screen.element.Pager;
import io.github.mortuusars.exposure.gui.screen.element.TextBlock;
import io.github.mortuusars.exposure.gui.screen.element.textbox.HorizontalAlignment;
import io.github.mortuusars.exposure.gui.screen.element.textbox.TextBox;
import io.github.mortuusars.exposure.item.AlbumPage;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.menu.AlbumMenu;
import io.github.mortuusars.exposure.menu.AlbumPlayerInventorySlot;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.AlbumSyncNoteC2SP;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.util.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlbumScreen
extends AbstractContainerScreen<AlbumMenu> {
    public static final ResourceLocation TEXTURE = Exposure.resource("textures/gui/album.png");
    public static final int MAIN_FONT_COLOR = -4876428;
    public static final int SECONDARY_FONT_COLOR = -1055542;
    public static final int SELECTION_COLOR = -7829249;
    public static final int SELECTION_UNFOCUSED_COLOR = -4473857;
    @NotNull
    protected final Minecraft minecraft;
    @NotNull
    protected final Player player;
    @NotNull
    protected final MultiPlayerGameMode gameMode;
    protected final Pager pager = new Pager(SoundEvents.f_11713_){

        @Override
        public void onPageChanged(PagingDirection pagingDirection, int prevPage, int currentPage) {
            super.onPageChanged(pagingDirection, prevPage, currentPage);
            AlbumScreen.this.sendButtonClick(pagingDirection == PagingDirection.PREVIOUS ? 0 : 1);
        }
    };
    protected final List<Page> pages = new ArrayList<Page>();
    @Nullable
    protected Button enterSignModeButton;

    public AlbumScreen(AlbumMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.minecraft = Minecraft.m_91087_();
        this.player = (Player)Objects.requireNonNull(this.minecraft.f_91074_);
        this.gameMode = Objects.requireNonNull(this.minecraft.f_91072_);
    }

    protected void m_181908_() {
        this.forEachPage(page -> page.noteWidget.ifLeft(TextBox::tick));
    }

    protected void m_7856_() {
        this.f_97726_ = 298;
        this.f_97727_ = 188;
        super.m_7856_();
        this.f_97729_ = -999;
        this.f_97730_ = 69;
        this.f_97731_ = -999;
        this.pages.clear();
        Page leftPage = this.createPage(Side.LEFT, 0);
        this.pages.add(leftPage);
        ImageButton previousButton = new ImageButton(this.f_97735_ + 12, this.f_97736_ + 164, 13, 15, 216, 188, 15, TEXTURE, 512, 512, button -> this.pager.changePage(PagingDirection.PREVIOUS), (Component)Component.m_237115_((String)"gui.exposure.previous_page"));
        previousButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure.previous_page")));
        this.m_142416_((GuiEventListener)previousButton);
        Page rightPage = this.createPage(Side.RIGHT, 140);
        this.pages.add(rightPage);
        ImageButton nextButton = new ImageButton(this.f_97735_ + 273, this.f_97736_ + 164, 13, 15, 229, 188, 15, TEXTURE, 512, 512, button -> this.pager.changePage(PagingDirection.NEXT), (Component)Component.m_237115_((String)"gui.exposure.next_page"));
        nextButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure.next_page")));
        this.m_142416_((GuiEventListener)nextButton);
        if (((AlbumMenu)this.m_6262_()).isAlbumEditable()) {
            this.enterSignModeButton = new ImageButton(this.f_97735_ - 23, this.f_97736_ + 17, 22, 22, 242, 188, 22, TEXTURE, 512, 512, b -> this.enterSignMode(), (Component)Component.m_237115_((String)"gui.exposure.album.sign"));
            this.enterSignModeButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure.album.sign")));
            this.m_142416_((GuiEventListener)this.enterSignModeButton);
        }
        int spreadsCount = (int)Math.ceil((float)((AlbumMenu)this.m_6262_()).getPages().size() / 2.0f);
        this.pager.init(spreadsCount, false, (AbstractButton)previousButton, (AbstractButton)nextButton);
    }

    protected Page createPage(Side side, int xOffset) {
        Either noteWidget;
        int x = this.f_97735_ + xOffset;
        int y = this.f_97736_;
        Rect2i page = new Rect2i(x, y, 149, 188);
        Rect2i photo = new Rect2i(x + 25, y + 21, 108, 108);
        Rect2i exposure = new Rect2i(x + 31, y + 27, 96, 96);
        Rect2i note = new Rect2i(x + 22, y + 133, 114, 27);
        PhotographSlotButton photographButton = new PhotographSlotButton(exposure, photo.m_110085_(), photo.m_110086_(), photo.m_110090_(), photo.m_110091_(), 0, 188, 108, TEXTURE, 512, 512, b -> {
            PhotographSlotButton button = (PhotographSlotButton)b;
            ItemStack photograph = button.getPhotograph();
            if (photograph.m_41619_()) {
                if (button.isEditable) {
                    this.sendButtonClick(side == Side.LEFT ? 2 : 3);
                    button.m_7435_(this.minecraft.m_91106_());
                }
            } else {
                this.inspectPhotograph(photograph);
            }
        }, b -> {
            PhotographSlotButton button = (PhotographSlotButton)b;
            if (button.isEditable && !button.getPhotograph().m_41619_()) {
                this.sendButtonClick(side == Side.LEFT ? 2 : 3);
                this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Exposure.SoundEvents.PHOTOGRAPH_PLACE.get(), (float)0.7f, (float)1.1f));
            }
        }, () -> ((AlbumMenu)this.m_6262_()).getPhotograph(side), ((AlbumMenu)this.m_6262_()).isAlbumEditable()){

            @Override
            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return !AlbumScreen.this.isInAddingMode() && super.m_6375_(mouseX, mouseY, button);
            }

            public boolean m_274382_() {
                return !AlbumScreen.this.isInAddingMode() && super.m_274382_();
            }
        };
        this.m_142416_((GuiEventListener)photographButton);
        if (((AlbumMenu)this.m_6262_()).isAlbumEditable()) {
            TextBox textBox = new TextBox(this.f_96547_, note.m_110085_(), note.m_110086_(), note.m_110090_(), note.m_110091_(), () -> ((AlbumMenu)this.m_6262_()).getPage(side).map(p -> (String)p.getNote().left().orElseThrow()).orElse(""), text -> this.onNoteChanged(side, (String)text)).setFontColor(-4876428, -4876428).setSelectionColor(-7829249, -4473857);
            textBox.horizontalAlignment = HorizontalAlignment.CENTER;
            this.m_142416_((GuiEventListener)textBox);
            noteWidget = Either.left((Object)((Object)textBox));
        } else {
            TextBlock textBlock = new TextBlock(this.f_96547_, note.m_110085_(), note.m_110086_(), note.m_110090_(), note.m_110091_(), this.getNoteComponent(side), this::m_5561_);
            textBlock.fontColor = -4876428;
            textBlock.alignment = HorizontalAlignment.CENTER;
            textBlock.drawShadow = false;
            noteWidget = Either.right((Object)((Object)textBlock));
        }
        return new Page(side, page, photo, exposure, note, photographButton, (Either<TextBox, TextBlock>)noteWidget);
    }

    protected void onNoteChanged(Side side, String noteText) {
        ((AlbumMenu)this.m_6262_()).getPage(side).ifPresent(page -> {
            page.setNote((Either<String, Component>)Either.left((Object)noteText));
            int pageIndex = ((AlbumMenu)this.m_6262_()).getCurrentSpreadIndex() * 2 + side.getIndex();
            Packets.sendToServer(new AlbumSyncNoteC2SP(pageIndex, noteText));
        });
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.pager.update();
        if (this.enterSignModeButton != null) {
            this.enterSignModeButton.f_93624_ = ((AlbumMenu)this.m_6262_()).canSignAlbum();
        }
        boolean isInAddingPhotographMode = this.isInAddingMode();
        this.forEachPage(page -> {
            page.getNoteWidget().f_93624_ = !isInAddingPhotographMode;
        });
        for (Page page2 : this.pages) {
            page2.photographButton.f_93624_ = !((AlbumMenu)this.m_6262_()).getPhotograph(page2.side).m_41619_() || !isInAddingPhotographMode && ((AlbumMenu)this.m_6262_()).isAlbumEditable();
        }
        this.f_97731_ = isInAddingPhotographMode ? ((AlbumMenu)this.m_6262_()).getPlayerInventorySlots().get((int)0).f_40221_ - 12 : -999;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        for (Page page2 : this.pages) {
            AbstractWidget noteWidget = page2.getNoteWidget();
            if (!(noteWidget instanceof TextBlock)) continue;
            TextBlock textBlock = (TextBlock)noteWidget;
            textBlock.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (isInAddingPhotographMode) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (Slot slot : ((AlbumMenu)this.m_6262_()).f_38839_) {
                if (slot.m_7993_().m_41619_() || slot.m_7993_().m_41720_() instanceof PhotographItem) continue;
                guiGraphics.m_280398_(TEXTURE, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 350, 176.0f, 404.0f, 18, 18, 512, 512);
            }
            RenderSystem.disableBlend();
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 15.0f);
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280168_().m_85849_();
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        if (this.isInAddingMode() && this.f_97734_ != null && !this.f_97734_.m_7993_().m_41619_() && !(this.f_97734_.m_7993_().m_41720_() instanceof PhotographItem)) {
            return;
        }
        if (!this.isInAddingMode()) {
            for (Page page : this.pages) {
                boolean hasText;
                if (page.photographButton.m_198029_()) {
                    page.photographButton.renderTooltip(guiGraphics, x, y);
                    return;
                }
                if (!((AlbumMenu)this.m_6262_()).isAlbumEditable() || !page.isMouseOver(page.noteArea, x, y)) continue;
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                tooltip.add(Component.m_237115_((String)"gui.exposure.album.note"));
                if (!page.getNoteWidget().m_93696_()) {
                    tooltip.add(Component.m_237115_((String)"gui.exposure.album.left_click_to_edit"));
                }
                if (hasText = page.noteWidget.left().map(box -> !box.getText().isEmpty()).orElse(false).booleanValue()) {
                    tooltip.add(Component.m_237115_((String)"gui.exposure.album.right_click_to_clear"));
                }
                guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), x, y);
                return;
            }
        }
        super.m_280072_(guiGraphics, x, y);
    }

    @NotNull
    protected List<Component> m_280553_(ItemStack stack) {
        List tooltipLines = super.m_280553_(stack);
        if (this.isInAddingMode() && this.f_97734_ != null && this.f_97734_.m_7993_() == stack && stack.m_41720_() instanceof PhotographItem) {
            tooltipLines.add(Component.m_237119_());
            tooltipLines.add(Component.m_237115_((String)"gui.exposure.album.left_click_to_add"));
        }
        return tooltipLines;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280398_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 512);
        if (this.enterSignModeButton != null && this.enterSignModeButton.f_93624_) {
            guiGraphics.m_280163_(TEXTURE, this.f_97735_ - 27, this.f_97736_ + 14, 447.0f, 0.0f, 27, 28, 512, 512);
        }
        int currentSpreadIndex = ((AlbumMenu)this.m_6262_()).getCurrentSpreadIndex();
        this.drawPageNumbers(guiGraphics, currentSpreadIndex);
        if (this.isInAddingMode()) {
            @Nullable Side pageBeingAddedTo = ((AlbumMenu)this.m_6262_()).getSideBeingAddedTo();
            for (Page page : this.pages) {
                if (page.side != pageBeingAddedTo) continue;
                guiGraphics.m_280398_(TEXTURE, page.photoArea.m_110085_(), page.photoArea.m_110086_(), 10, 0.0f, 296.0f, page.photoArea.m_110090_(), page.photoArea.m_110091_(), 512, 512);
                break;
            }
            AlbumPlayerInventorySlot firstSlot = ((AlbumMenu)this.m_6262_()).getPlayerInventorySlots().get(0);
            int x = firstSlot.f_40220_ - 8;
            int y = firstSlot.f_40221_ - 18;
            guiGraphics.m_280398_(TEXTURE, this.f_97735_ + x, this.f_97736_ + y, 10, 0.0f, 404.0f, 176, 100, 512, 512);
        }
    }

    protected void drawPageNumbers(GuiGraphics guiGraphics, int currentSpreadIndex) {
        Font font = this.minecraft.f_91062_;
        String leftPageNumber = Integer.toString(currentSpreadIndex * 2 + 1);
        String rightPageNumber = Integer.toString(currentSpreadIndex * 2 + 2);
        guiGraphics.m_280056_(font, leftPageNumber, this.f_97735_ + 71 + (8 - font.m_92895_(leftPageNumber) / 2), this.f_97736_ + 167, -1055542, false);
        guiGraphics.m_280056_(font, rightPageNumber, this.f_97735_ + 212 + (8 - font.m_92895_(rightPageNumber) / 2), this.f_97736_ + 167, -1055542, false);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isInAddingMode()) {
            if (!(this.isHoveringOverInventory(mouseX, mouseY) || this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, button) && !((AlbumMenu)this.m_6262_()).m_142621_().m_41619_())) {
                this.sendButtonClick(-1);
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
        for (Page page : this.pages) {
            if (!((AlbumMenu)this.m_6262_()).isAlbumEditable() || button != 1 || !page.isMouseOver(page.noteArea, mouseX, mouseY)) continue;
            page.noteWidget.ifLeft(box -> box.setText(""));
            return true;
        }
        boolean handled = super.m_6375_(mouseX, mouseY, button);
        for (Page page : this.pages) {
            TextBlock textBlock;
            AbstractWidget noteWidget = page.getNoteWidget();
            if (!(noteWidget instanceof TextBlock) || !(textBlock = (TextBlock)noteWidget).m_6375_(mouseX, mouseY, button)) continue;
            handled = true;
            break;
        }
        for (Page page : this.pages) {
            if (!page.getNoteWidget().m_93696_() || page.isMouseOver(page.noteArea, mouseX, mouseY)) continue;
            this.m_7522_(null);
            return true;
        }
        if (!(this.m_7222_() instanceof TextBox)) {
            this.m_7522_(null);
        }
        return handled;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.f_97738_ && !((AlbumMenu)this.m_6262_()).m_142621_().m_41619_() && ((AlbumMenu)this.m_6262_()).m_142621_().m_41613_() == 1) {
            this.f_97738_ = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_5561_(@Nullable Style style) {
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.m_131182_();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
            String pageIndexStr = clickEvent.m_130623_();
            int pageIndex = Integer.parseInt(pageIndexStr) - 1;
            this.forcePage(pageIndex);
            return true;
        }
        boolean handled = super.m_5561_(style);
        if (handled && clickEvent.m_130622_() == ClickEvent.Action.RUN_COMMAND) {
            this.m_7379_();
        }
        return handled;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isInAddingMode()) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    protected void sendButtonClick(int buttonId) {
        ((AlbumMenu)this.m_6262_()).m_6366_(this.player, buttonId);
        this.gameMode.m_105208_(((AlbumMenu)this.m_6262_()).f_38840_, buttonId);
        if (buttonId == -1) {
            this.m_7522_(null);
        }
        if (buttonId == 0 || buttonId == 1) {
            for (Page page : this.pages) {
                page.noteWidget.ifLeft(TextBox::setCursorToEnd).ifRight(textBlock -> textBlock.m_93666_(this.getNoteComponent(page.side)));
            }
        }
    }

    protected boolean isHoveringOverInventory(double mouseX, double mouseY) {
        if (!this.isInAddingMode()) {
            return false;
        }
        AlbumPlayerInventorySlot firstSlot = ((AlbumMenu)this.m_6262_()).getPlayerInventorySlots().get(0);
        int x = firstSlot.f_40220_ - 8;
        int y = firstSlot.f_40221_ - 18;
        return this.m_6774_(x, y, 176, 100, mouseX, mouseY);
    }

    protected boolean isHoveringOverSignElement(double mouseX, double mouseY) {
        return this.enterSignModeButton == null || this.enterSignModeButton.f_93624_ && this.m_6774_(this.f_97735_ - 27, this.f_97736_ + 14, 27, 28, mouseX, mouseY);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.m_7467_(mouseX, mouseY, guiLeft, guiTop, mouseButton) && !this.isHoveringOverInventory(mouseX, mouseY) && !this.isHoveringOverSignElement(mouseX, mouseY);
    }

    protected boolean forcePage(int pageIndex) {
        try {
            int newSpreadIndex = pageIndex / 2;
            if (newSpreadIndex == ((AlbumMenu)this.m_6262_()).getCurrentSpreadIndex() || newSpreadIndex < 0 || newSpreadIndex > ((AlbumMenu)this.m_6262_()).getPages().size() / 2) {
                return false;
            }
            PagingDirection pagingDirection = newSpreadIndex < ((AlbumMenu)this.m_6262_()).getCurrentSpreadIndex() ? PagingDirection.PREVIOUS : PagingDirection.NEXT;
            for (int pageChanges = 0; !(newSpreadIndex == ((AlbumMenu)this.m_6262_()).getCurrentSpreadIndex() && this.pager.canChangePage(pagingDirection) || pageChanges > 16); ++pageChanges) {
                this.pager.changePage(pagingDirection);
            }
            return true;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot force page: {}", (Object)e.toString());
            return false;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        for (Page page : this.pages) {
            AbstractWidget widget = (AbstractWidget)page.noteWidget.map(box -> box, block -> block);
            if (!widget.m_93696_()) continue;
            if (keyCode == 256) {
                this.m_7522_(null);
                return true;
            }
            return widget.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.isInAddingMode() && (this.minecraft.f_91066_.f_92092_.m_90832_(keyCode, scanCode) || keyCode == 256)) {
            this.sendButtonClick(-1);
            return true;
        }
        return this.pager.handleKeyPressed(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        for (Page page : this.pages) {
            if (!((AbstractWidget)page.noteWidget.map(box -> box, block -> block)).m_93696_()) continue;
            return super.m_7920_(keyCode, scanCode, modifiers);
        }
        return this.pager.handleKeyReleased(keyCode, scanCode, modifiers) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    protected void inspectPhotograph(ItemStack photograph) {
        if (!(photograph.m_41720_() instanceof PhotographItem)) {
            return;
        }
        this.minecraft.m_91152_((Screen)new AlbumPhotographScreen((Screen)this, List.of(new ItemAndStack(photograph))));
        this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), (float)(this.player.m_9236_().m_213780_().m_188501_() * 0.2f + 1.3f), (float)0.75f));
    }

    @NotNull
    protected Component getNoteComponent(Side page) {
        return ((AlbumMenu)this.m_6262_()).getPage(page).map(AlbumPage::getNote).map(n -> (Component)n.map(Component::m_237113_, comp -> comp)).orElse((Component)Component.m_237119_());
    }

    protected void enterSignMode() {
        if (this.isInAddingMode()) {
            this.sendButtonClick(-1);
        }
        this.minecraft.m_91152_((Screen)new AlbumSigningScreen((Screen)this, TEXTURE, 512, 512));
    }

    protected boolean isInAddingMode() {
        return ((AlbumMenu)this.m_6262_()).isInAddingPhotographMode();
    }

    protected void forEachPage(Consumer<Page> pageAction) {
        for (Page page : this.pages) {
            pageAction.accept(page);
        }
    }

    protected class Page {
        public final Side side;
        public final Rect2i pageArea;
        public final Rect2i photoArea;
        public final Rect2i exposureArea;
        public final Rect2i noteArea;
        public final PhotographSlotButton photographButton;
        public final Either<TextBox, TextBlock> noteWidget;

        private Page(Side side, Rect2i pageArea, Rect2i photoArea, Rect2i exposureArea, Rect2i noteArea, PhotographSlotButton photographButton, Either<TextBox, TextBlock> noteWidget) {
            this.side = side;
            this.pageArea = pageArea;
            this.photoArea = photoArea;
            this.exposureArea = exposureArea;
            this.noteArea = noteArea;
            this.photographButton = photographButton;
            this.noteWidget = noteWidget;
        }

        public boolean isMouseOver(Rect2i area, double mouseX, double mouseY) {
            return AlbumScreen.this.m_6774_(area.m_110085_() - AlbumScreen.this.f_97735_, area.m_110086_() - AlbumScreen.this.f_97736_, area.m_110090_(), area.m_110091_(), mouseX, mouseY);
        }

        public AbstractWidget getNoteWidget() {
            return (AbstractWidget)this.noteWidget.map(box -> box, block -> block);
        }
    }
}

