/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.net.covers1624.quack.platform;

import java.util.Locale;

public enum OperatingSystem {
    WINDOWS,
    MACOS,
    LINUX,
    SOLARIS,
    FREEBSD,
    UNKNOWN;

    private static final OperatingSystem CURRENT;

    public static OperatingSystem current() {
        return CURRENT;
    }

    public static OperatingSystem parse(String name) {
        if ((name = name.toLowerCase(Locale.ROOT)).contains("windows")) {
            return WINDOWS;
        }
        if (name.contains("linux")) {
            return LINUX;
        }
        if (name.contains("osx") || name.contains("os x") || name.contains("darwin")) {
            return MACOS;
        }
        if (name.contains("sunos") || name.contains("solaris")) {
            return SOLARIS;
        }
        if (name.contains("freebsd")) {
            return FREEBSD;
        }
        return UNKNOWN;
    }

    public boolean isWindows() {
        return this == WINDOWS;
    }

    public boolean isMacos() {
        return this == MACOS;
    }

    public boolean isLinux() {
        return this == LINUX;
    }

    public boolean isSolaris() {
        return this == SOLARIS;
    }

    public boolean isFreebsd() {
        return this == FREEBSD;
    }

    public boolean isUnixLike() {
        return this == MACOS || this == LINUX || this == SOLARIS || this == FREEBSD;
    }

    public String exeSuffix(String file) {
        if (this == WINDOWS) {
            return file + ".exe";
        }
        return file;
    }

    static {
        CURRENT = OperatingSystem.parse(System.getProperty("os.name"));
    }
}

