/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.creeperhost.ftbbackups.FTBBackups;
import net.creeperhost.ftbbackups.MCNBTImpl;
import net.creeperhost.ftbbackups.config.Config;
import net.creeperhost.ftbbackups.config.Format;
import net.creeperhost.ftbbackups.config.RetentionMode;
import net.creeperhost.ftbbackups.data.Backup;
import net.creeperhost.ftbbackups.data.Backups;
import net.creeperhost.ftbbackups.utils.FileUtils;
import net.creeperhost.ftbbackups.utils.TieredBackupTest;
import net.creeperhost.levelio.LevelIO;
import net.creeperhost.levelio.data.Level;
import net.creeperhost.levelpreview.ActivityScanner;
import net.creeperhost.levelpreview.CaptureHandler;
import net.creeperhost.levelpreview.ColourMap;
import net.creeperhost.levelpreview.LevelPreview;
import net.creeperhost.levelpreview.lib.CaptureArea;
import net.creeperhost.levelpreview.lib.SimplePNG;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class BackupHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final LevelPreview PREVIEW = new LevelPreview(new MCNBTImpl());
    private static Path serverRoot;
    private static Path backupFolderPath;
    private static Path worldFolder;
    public static final AtomicBoolean backupRunning;
    private static final AtomicBoolean backupFailed;
    private static AtomicReference<String> backupPreview;
    private static boolean isSpaceConstrained;
    public static boolean isDirty;
    public static AtomicReference<Backups> backups;
    private static String failReason;
    private static long lastAutoBackup;
    public static CompletableFuture<Void> currentFuture;
    public static Path defaultBackupLocation;

    public static void init(MinecraftServer minecraftServer) {
        block5: {
            serverRoot = minecraftServer.m_6237_().toPath().normalize().toAbsolutePath();
            defaultBackupLocation = serverRoot.resolve("backups");
            if (!Config.cached().backup_location.equalsIgnoreCase(".")) {
                try {
                    Path configPath = Path.of(Config.cached().backup_location, new String[0]);
                    if (Files.exists(configPath, new LinkOption[0])) {
                        FTBBackups.LOGGER.info("Using configured backups directory at {}", (Object)configPath.toAbsolutePath());
                        backupFolderPath = configPath;
                        break block5;
                    }
                    FTBBackups.LOGGER.error(configPath.toAbsolutePath() + " does not exist, please create the directory before continuing");
                    backupFolderPath = defaultBackupLocation;
                }
                catch (Exception e) {
                    FTBBackups.LOGGER.error("Unable to find backup folder from config {} using default {}", (Object)Config.cached().backup_location, (Object)defaultBackupLocation.toAbsolutePath());
                    e.printStackTrace();
                    backupFolderPath = defaultBackupLocation;
                }
            } else {
                backupFolderPath = defaultBackupLocation;
            }
        }
        BackupHandler.createBackupFolder(defaultBackupLocation);
        BackupHandler.createBackupFolder(backupFolderPath);
        BackupHandler.loadJson();
        BackupHandler.initPreview();
    }

    private static void initPreview() {
        ColourMap colourMap = PREVIEW.getColourMap();
        CaptureHandler.init(1);
        for (ResourceLocation regName : BuiltInRegistries.f_256975_.m_6566_()) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(regName);
            int colour = block.m_284356_().f_283871_;
            colourMap.addBlockMapping(regName.toString(), colour);
        }
    }

    public static String createPreview(MinecraftServer minecraftServer) {
        try {
            CaptureArea area;
            long scanStart = System.currentTimeMillis();
            Path worldPath = minecraftServer.m_129843_(LevelResource.f_78182_).toAbsolutePath();
            PREVIEW.loadWorld(worldPath);
            LevelIO levelIO = PREVIEW.getLevelIO();
            String previewDim = Config.cached().preview_dimension;
            if ("all".equals(previewDim)) {
                ArrayList<ActivityScanner> scanners = new ArrayList<ActivityScanner>();
                for (Level level : levelIO.getLevels()) {
                    ActivityScanner scanner = new ActivityScanner(levelIO, level, 1);
                    if (!scanner.findActivityClusters(512, 512, 1)) continue;
                    scanners.add(scanner);
                }
                if (scanners.isEmpty()) {
                    return "";
                }
                scanners.sort(Comparator.comparingDouble(ActivityScanner::getTotalHabitationFactor).reversed());
                ActivityScanner scanner = (ActivityScanner)scanners.get(0);
                area = scanner.getResults().get(0);
            } else {
                ActivityScanner scanner;
                Level level = levelIO.getLevel(previewDim);
                if (level == null) {
                    FTBBackups.LOGGER.error("Could not find specified dimension {}, using overworld", (Object)previewDim);
                    level = levelIO.getLevel("minecraft:overworld");
                    if (level == null) {
                        FTBBackups.LOGGER.warn("overworld dimension not found, will not create backup preview image");
                        return "";
                    }
                }
                if (!(scanner = new ActivityScanner(levelIO, level, 1)).findActivityClusters(512, 512, 1)) {
                    return "";
                }
                area = scanner.getResults().get(0);
            }
            long captureStart = System.currentTimeMillis();
            SimplePNG.SimpleImg capture = PREVIEW.newCapture().captureArea(area).doCapture().getImage();
            PREVIEW.close();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            SimplePNG.writePNG(os, capture);
            byte[] image = os.toByteArray();
            FTBBackups.LOGGER.info("Backup preview created, Scan took {}ms, Capture took {}ms", (Object)(captureStart - scanStart), (Object)(System.currentTimeMillis() - captureStart));
            return "data:image/png;base64, " + Base64.getEncoder().encodeToString(image);
        }
        catch (Exception ex) {
            FTBBackups.LOGGER.error("An error occurred while generating backup preview", (Throwable)ex);
            return "";
        }
    }

    public static boolean isRunning() {
        return backupRunning.get();
    }

    public static void createBackup(MinecraftServer minecraftServer) {
        BackupHandler.createBackup(minecraftServer, false, "automated");
    }

    public static void createBackup(MinecraftServer minecraftServer, boolean protect, String name) {
        try {
            if (FTBBackups.isShutdown || !Config.cached().enabled) {
                return;
            }
            if (Config.cached().only_if_players_been_online && !isDirty) {
                FTBBackups.LOGGER.info("Skipping backup, no players have been online since last backup.");
                return;
            }
            worldFolder = minecraftServer.m_129843_(LevelResource.f_78182_).toAbsolutePath();
            FTBBackups.LOGGER.info("Found world folder at " + worldFolder);
            String backupName = TieredBackupTest.getBackupName();
            Path backupLocation = backupFolderPath.resolve(backupName);
            Format format = Config.cached().backup_format;
            if (BackupHandler.canCreateBackup()) {
                lastAutoBackup = TieredBackupTest.getBackupTime();
                backupRunning.set(true);
                CompletableFuture saveOp = minecraftServer.m_18707_(() -> {
                    if (!minecraftServer.m_195518_()) {
                        minecraftServer.m_195514_(true, false, true);
                    }
                });
                BackupHandler.setNoSave(minecraftServer, true);
                AtomicLong startTime = new AtomicLong(System.nanoTime());
                AtomicLong finishTime = new AtomicLong();
                Backup backup = new Backup(worldFolder.normalize().getFileName().toString(), lastAutoBackup, backupLocation.toString(), 0L, 0.0f, "", backupPreview.get(), protect, name, format, false);
                BackupHandler.addBackup(backup);
                BackupHandler.updateJson();
                currentFuture = CompletableFuture.runAsync(() -> {
                    block26: {
                        try {
                            if (!saveOp.isDone()) {
                                FTBBackups.LOGGER.info("Waiting for world save to complete.");
                                saveOp.get(30L, TimeUnit.SECONDS);
                            }
                            BackupHandler.alertPlayers(minecraftServer, (Component)Component.m_237115_((String)"ftbbackups2.backup.starting"));
                            Path backupPath = backupFolderPath.resolve(backupName);
                            LinkedList<Path> backupPaths = new LinkedList<Path>();
                            backupPaths.add(worldFolder);
                            try (Stream<Path> pathStream = Files.walk(serverRoot, new FileVisitOption[0]);){
                                for (Path path : pathStream::iterator) {
                                    Path relFile;
                                    if (Files.isDirectory(path, new LinkOption[0]) || !FileUtils.matchesAny(relFile = serverRoot.relativize(path), Config.cached().additional_files)) continue;
                                    try {
                                        if (!FileUtils.isChildOf(path, serverRoot)) {
                                            FTBBackups.LOGGER.warn("Ignoring additional file {}, as it is not a child of the server root directory.", (Object)relFile);
                                            continue;
                                        }
                                        if (FileUtils.isChildOf(path, worldFolder)) {
                                            FTBBackups.LOGGER.warn("Ignoring additional file {}, as it is a child of the world folder.", (Object)relFile);
                                            continue;
                                        }
                                        if (FileUtils.isChildOf(path, backupFolderPath)) {
                                            FTBBackups.LOGGER.warn("Ignoring additional file {}, as it is a child of the backups folder.", (Object)relFile);
                                            continue;
                                        }
                                        if (!Files.exists(path, new LinkOption[0])) continue;
                                        backupPaths.add(path);
                                    }
                                    catch (Exception err) {
                                        FTBBackups.LOGGER.error("Failed to add additional file '{}' to the backup.", (Object)relFile, (Object)err);
                                    }
                                }
                            }
                            for (String p : Config.cached().additional_directories) {
                                try {
                                    Path path;
                                    path = serverRoot.resolve(p);
                                    if (!FileUtils.isChildOf(path, serverRoot)) {
                                        FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is not a child of the server root directory.", (Object)p);
                                        continue;
                                    }
                                    if (path.equals(worldFolder)) {
                                        FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is the world folder.", (Object)p);
                                        continue;
                                    }
                                    if (FileUtils.isChildOf(path, worldFolder)) {
                                        FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is a child of the world folder.", (Object)p);
                                        continue;
                                    }
                                    if (FileUtils.isChildOf(path, backupFolderPath)) {
                                        FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is a child of the backups folder.", (Object)p);
                                        continue;
                                    }
                                    if (!Files.isDirectory(path, new LinkOption[0])) {
                                        FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is not a directory..", (Object)p);
                                        continue;
                                    }
                                    if (!Files.exists(path, new LinkOption[0])) continue;
                                    backupPaths.add(path);
                                }
                                catch (Exception err) {
                                    FTBBackups.LOGGER.error("Failed to add additional directory '{}' to the backup.", (Object)p, (Object)err);
                                }
                            }
                            backupPreview.set(BackupHandler.createPreview(minecraftServer));
                            if (format == Format.ZIP) {
                                FileUtils.zip(backupPath, serverRoot, backupPaths);
                            } else {
                                FileUtils.copy(backupPath, serverRoot, backupPaths);
                            }
                            backupFailed.set(false);
                            isDirty = false;
                        }
                        catch (Exception e) {
                            backupRunning.set(false);
                            backupFailed.set(true);
                            BackupHandler.alertPlayers(minecraftServer, (Component)Component.m_237115_((String)"ftbbackups2.backup.failed"));
                            FTBBackups.LOGGER.error("Failed to create backup", (Throwable)e);
                            if (!(e instanceof FileAlreadyExistsException)) break block26;
                            ++TieredBackupTest.testBackupCount;
                        }
                    }
                }, FTBBackups.backupExecutor).thenRun(() -> {
                    String sha1;
                    currentFuture = null;
                    BackupHandler.setNoSave(minecraftServer, false);
                    if (backupFailed.get()) {
                        backupFailed.set(false);
                        backupRunning.set(false);
                        return;
                    }
                    finishTime.set(System.nanoTime());
                    long elapsedTime = finishTime.get() - startTime.get();
                    backupRunning.set(false);
                    BackupHandler.alertPlayers(minecraftServer, (Component)Component.m_237115_((String)("Backup finished in " + BackupHandler.format(elapsedTime) + (String)(Config.cached().display_file_size ? " Size: " + FileUtils.getSizeString(backupLocation.toFile().length()) : ""))));
                    float ratio = 1.0f;
                    long backupSize = FileUtils.getSize(backupLocation.toFile());
                    if (format == Format.ZIP) {
                        sha1 = FileUtils.getFileSha1(backupLocation);
                        ratio = (float)backupSize / (float)FileUtils.getFolderSize(worldFolder.toFile());
                    } else {
                        sha1 = FileUtils.getDirectorySha1(backupLocation);
                    }
                    FTBBackups.LOGGER.info("Backup size " + FileUtils.getSizeString(backupLocation.toFile().length()) + " World Size " + FileUtils.getSizeString(FileUtils.getFolderSize(worldFolder.toFile())));
                    backup.setRatio(ratio).setSha1(sha1).setComplete();
                    backup.setSize(backupSize);
                    BackupHandler.updateJson();
                    FTBBackups.LOGGER.info("New backup created at " + backupLocation + " size: " + FileUtils.getSizeString(backupLocation) + " Took: " + BackupHandler.format(elapsedTime) + " Sha1: " + sha1);
                    ++TieredBackupTest.testBackupCount;
                });
            } else {
                if (!failReason.isEmpty()) {
                    backupRunning.set(false);
                    Object failMessage = "Unable to create backup, Reason: " + failReason;
                    BackupHandler.alertPlayers(minecraftServer, (Component)Component.m_237115_((String)failMessage));
                    FTBBackups.LOGGER.error((String)failMessage);
                    failMessage = "";
                }
                backupRunning.set(false);
            }
        }
        catch (Exception e) {
            FTBBackups.LOGGER.error("An error occurred while running backup!", (Throwable)e);
            backupRunning.set(false);
        }
    }

    public static String genBackupFileName() {
        Calendar calendar = Calendar.getInstance();
        String date = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
        String time = calendar.get(11) + "-" + calendar.get(12) + "-" + calendar.get(13);
        String backupName = date + "_" + time;
        if (Config.cached().backup_format == Format.ZIP) {
            backupName = backupName + ".zip";
        }
        return backupName;
    }

    public static void addBackup(Backup backup) {
        backups.getAndUpdate(backups1 -> {
            backups1.add(backup);
            return backups1;
        });
    }

    public static void removeBackup(Backup backup) {
        backups.getAndUpdate(backups1 -> {
            if (backups1.contains(backup)) {
                backups1.remove(backup);
                return backups1;
            }
            return backups1;
        });
    }

    @Nullable
    public static Backup getLatestBackup() {
        if (backups == null) {
            return null;
        }
        if (backups.get().isEmpty()) {
            return null;
        }
        Backup currentNewest = null;
        for (Backup backup : backups.get().getBackups()) {
            if (currentNewest == null) {
                currentNewest = backup;
            }
            if (backup.getCreateTime() <= currentNewest.getCreateTime()) continue;
            currentNewest = backup;
        }
        return currentNewest;
    }

    @Nullable
    public static Backup getOldestBackup() {
        if (backups.get().isEmpty()) {
            return null;
        }
        Backup currentOldest = null;
        for (Backup backup : backups.get().getBackups()) {
            if (backup.isProtected()) continue;
            if (currentOldest == null) {
                currentOldest = backup;
            }
            if (backup.getCreateTime() >= currentOldest.getCreateTime()) continue;
            currentOldest = backup;
        }
        return currentOldest;
    }

    public static void clean() {
        if (FTBBackups.isShutdown) {
            return;
        }
        if (backupRunning.get()) {
            return;
        }
        if (backups == null) {
            return;
        }
        if (Config.cached().retention_mode == RetentionMode.MAX_BACKUPS) {
            BackupHandler.cleanMax();
        } else {
            BackupHandler.cleanTiered();
        }
    }

    private static void cleanMax() {
        int backupsNeedRemoving = 0;
        if (backups.get().unprotectedSize() > Config.cached().max_backups) {
            FTBBackups.LOGGER.info("More backups than " + Config.cached().max_backups + " found, Removing oldest backup");
            backupsNeedRemoving = backups.get().unprotectedSize() - Config.cached().max_backups;
        } else if (isSpaceConstrained && Config.cached().free_space_if_needed) {
            FTBBackups.LOGGER.info("Insufficient space to create new backups, Removing oldest backup");
            isSpaceConstrained = false;
            backupsNeedRemoving = 1;
        }
        if (backupsNeedRemoving <= 0 || BackupHandler.getOldestBackup() == null) {
            return;
        }
        for (int i = 0; i < backupsNeedRemoving; ++i) {
            Backup oldest = BackupHandler.getOldestBackup();
            BackupHandler.deleteBackup(oldest);
        }
        BackupHandler.verifyOldBackups();
    }

    private static void cleanTiered() {
        ArrayList<Backup> backups = new ArrayList<Backup>(BackupHandler.backups.get().getBackups());
        backups.removeIf(Backup::isProtected);
        backups.sort(Comparator.comparingLong(Backup::getCreateTime).reversed());
        if (backups.size() <= Config.cached().keep_latest) {
            return;
        }
        LinkedHashMap<Backup, String> backupsToKeep = new LinkedHashMap<Backup, String>();
        if (Config.cached().keep_latest > 0) {
            for (Backup backup2 : backups.subList(0, Config.cached().keep_latest)) {
                backupsToKeep.put(backup2, "Latest");
            }
        }
        BackupHandler.computeRetained(backups, backupsToKeep, Config.cached().keep_hourly, 11);
        BackupHandler.computeRetained(backups, backupsToKeep, Config.cached().keep_daily, 6);
        BackupHandler.computeRetained(backups, backupsToKeep, Config.cached().keep_weekly, 3);
        BackupHandler.computeRetained(backups, backupsToKeep, Config.cached().keep_monthly, 2);
        backups.removeAll(backupsToKeep.keySet());
        for (Backup backup2 : backups) {
            if (!TieredBackupTest.shouldRemoveBackup(backup2)) continue;
            BackupHandler.deleteBackup(backup2);
        }
        BackupHandler.verifyOldBackups();
        if (!backups.isEmpty()) {
            backupsToKeep.forEach((backup, rule) -> FTBBackups.LOGGER.info("Keeping Backup: {}, Rule: {}", (Object)new Date(backup.getCreateTime()), rule));
        }
        TieredBackupTest.cycleComplete();
    }

    private static void computeRetained(List<Backup> backups, Map<Backup, String> retained, int keepNumber, int timeUnit) {
        String name = timeUnit == 11 ? "Hour" : (timeUnit == 6 ? "Day" : (timeUnit == 3 ? "Week" : "Month"));
        try {
            Calendar now = Calendar.getInstance();
            now.set(14, 0);
            now.set(13, 0);
            now.set(12, 0);
            if (timeUnit == 6) {
                now.set(11, 0);
            }
            if (timeUnit == 3) {
                now.set(11, 0);
                now.set(7, 0);
            }
            if (timeUnit == 2) {
                now.set(11, 0);
                now.set(5, 0);
            }
            for (int i = 0; i < keepNumber; ++i) {
                Calendar past = (Calendar)now.clone();
                past.add(timeUnit, -i);
                long end = past.getTimeInMillis();
                if (i == 0) {
                    end = Calendar.getInstance().getTimeInMillis();
                }
                past.add(timeUnit, -1);
                long start = past.getTimeInMillis();
                Backup latest = null;
                for (Backup backup : backups) {
                    long time = backup.getCreateTime();
                    if (time < start || time >= end || latest != null && time <= latest.getCreateTime()) continue;
                    latest = backup;
                }
                if (latest == null) continue;
                TieredBackupTest.willKeep(name, latest);
                String info = (String)(retained.containsKey(latest) ? retained.get(latest) + "&" : "") + name;
                retained.put(latest, info);
            }
        }
        catch (Throwable e) {
            FTBBackups.LOGGER.error("An error occurred computing which backups to retain", e);
        }
    }

    private static void deleteBackup(Backup backup) {
        try {
            Path backupFile = Path.of(backup.getBackupLocation(), new String[0]);
            if (Files.exists(backupFile, new LinkOption[0])) {
                String log = "Removed old backup " + backupFile.getFileName();
                if (backup.getBackupFormat() == Format.DIRECTORY) {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)backupFile.toFile());
                } else if (!Files.deleteIfExists(backupFile)) {
                    log = "Failed to remove backup " + backupFile.getFileName();
                }
                FTBBackups.LOGGER.info(log);
            }
        }
        catch (Exception e) {
            FTBBackups.LOGGER.info("An error occurred while deleting backup.", (Throwable)e);
        }
    }

    public static void loadJson() {
        Path json = defaultBackupLocation.resolve("backups.json");
        if (Files.exists(json, new LinkOption[0])) {
            Gson gson = new Gson();
            try {
                FileReader fileReader = new FileReader(json.toFile());
                backups.getAndUpdate(backups1 -> (Backups)gson.fromJson((Reader)fileReader, Backups.class));
                fileReader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateJson() {
        try {
            String jsonString = "[]";
            if (!backups.get().isEmpty()) {
                jsonString = GSON.toJson((Object)backups.get(), Backups.class);
            }
            BackupHandler.writeToFile(jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToFile(String json) {
        FTBBackups.LOGGER.info("Writing to file " + defaultBackupLocation.resolve("backups.json"));
        try (FileOutputStream fileOutputStream = new FileOutputStream(defaultBackupLocation.resolve("backups.json").toFile());){
            IOUtils.write((String)json, (OutputStream)fileOutputStream, (Charset)Charset.defaultCharset());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean canCreateBackup() {
        File worldFile = worldFolder.toFile();
        if (!worldFile.exists() || !worldFile.isDirectory()) {
            FTBBackups.LOGGER.info("World folder does not exist or is not a directory: {}", (Object)worldFile.getAbsolutePath());
            failReason = "Invalid world folder";
            return false;
        }
        if (backupFolderPath == null) {
            failReason = "backup folder path is null";
            return false;
        }
        if (!backupFolderPath.toFile().exists()) {
            failReason = "backup folder does not exist";
            return false;
        }
        if (backupRunning.get()) {
            FTBBackups.LOGGER.info("Unable to start new backup as backup is already running");
            failReason = "Unable to start new backup as backup is already running";
            return false;
        }
        if (lastAutoBackup != 0L && Config.cached().manual_backups_time != 0 && System.currentTimeMillis() < lastAutoBackup + 60000L) {
            failReason = "Manuel backup was recently taken";
            return false;
        }
        if (currentFuture != null) {
            failReason = "backup thread is somehow still running";
            FTBBackups.LOGGER.error("currentFuture is not null??");
            return false;
        }
        long minFreeSpace = Config.cached().minimum_free_space * 1000000L;
        long free = backupFolderPath.toFile().getFreeSpace() - minFreeSpace;
        long currentWorldSize = FileUtils.getFolderSize(worldFile);
        for (String p : Config.cached().additional_directories) {
            try {
                Path path2 = worldFolder.getParent().resolve(p);
                if (!Files.exists(path2, new LinkOption[0]) || !Files.isDirectory(path2, new LinkOption[0])) continue;
                currentWorldSize += FileUtils.getFolderSize(path2.toFile());
            }
            catch (Exception path2) {}
        }
        currentWorldSize += FileUtils.getFolderSize(serverRoot, path -> FileUtils.matchesAny(serverRoot.relativize((Path)path), Config.cached().additional_files));
        if (BackupHandler.getLatestBackup() == null) {
            FTBBackups.LOGGER.error("Current world size: " + FileUtils.getSizeString(currentWorldSize) + " Current Available space: " + FileUtils.getSizeString(free));
            if (currentWorldSize > free) {
                failReason = "not enough free space on device";
                isSpaceConstrained = true;
                return false;
            }
        } else {
            long latestBackupSize = BackupHandler.getLatestBackup().getSize();
            float ratio = BackupHandler.getLatestBackup().getRatio();
            long expectedSize = (long)((int)(Math.ceil((float)currentWorldSize * ratio) / 100.0)) * 105L;
            FTBBackups.LOGGER.info("Last backup size: " + FileUtils.getSizeString(latestBackupSize) + " Current world size: " + FileUtils.getSizeString(currentWorldSize) + " Current Available space: " + FileUtils.getSizeString(free) + " ExpectedSize " + FileUtils.getSizeString(expectedSize));
            if (expectedSize > free) {
                failReason = "not enough free space on device";
                isSpaceConstrained = true;
                return false;
            }
        }
        return true;
    }

    public static void verifyOldBackups() {
        if (backups == null) {
            return;
        }
        if (backups.get().isEmpty()) {
            return;
        }
        ArrayList<Backup> backupsCopy = new ArrayList<Backup>(backups.get().getBackups());
        boolean update = false;
        for (Backup backup : backupsCopy) {
            FTBBackups.LOGGER.debug("Verifying backup " + backup.getBackupLocation());
            if (Files.exists(Path.of(backup.getBackupLocation(), new String[0]), new LinkOption[0])) continue;
            BackupHandler.removeBackup(backup);
            update = true;
            FTBBackups.LOGGER.info("File missing, removing from backups " + backup.getBackupLocation());
        }
        if (update) {
            BackupHandler.updateJson();
        }
    }

    public static void createBackupFolder(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            boolean backupFolderCreated = path.toFile().mkdirs();
            String log = backupFolderCreated ? "Created backup folder at " + path.toAbsolutePath() : "Failed to create backup folder at " + path.toAbsolutePath();
            FTBBackups.LOGGER.info(log);
        }
    }

    public static void setNoSave(MinecraftServer minecraftServer, boolean value) {
        for (ServerLevel level : minecraftServer.m_129785_()) {
            if (level == null) continue;
            FTBBackups.LOGGER.info("Setting world " + level.m_46472_().m_135782_() + " save state to " + value);
            level.f_8564_ = value;
        }
    }

    public static void alertPlayers(MinecraftServer minecraftServer, Component message) {
        if (Config.cached().do_not_notify) {
            return;
        }
        if (Config.cached().notify_op_only && minecraftServer instanceof DedicatedServer) {
            for (ServerPlayer player : minecraftServer.m_6846_().m_11314_()) {
                if (!player.m_20310_(4)) continue;
                player.m_5661_(message, false);
            }
        } else {
            for (ServerPlayer player : minecraftServer.m_6846_().m_11314_()) {
                player.m_5661_(message, false);
            }
        }
    }

    public static String format(long nano) {
        Duration duration = Duration.ofNanos(nano);
        long mins = duration.toMinutes();
        long seconds = duration.minusMinutes(mins).toSeconds();
        long mili = duration.minusSeconds(seconds).toMillis();
        return mins + "m, " + seconds + "s, " + mili + "ms";
    }

    static {
        backupRunning = new AtomicBoolean(false);
        backupFailed = new AtomicBoolean(false);
        backupPreview = new AtomicReference<String>("");
        isSpaceConstrained = false;
        isDirty = false;
        backups = new AtomicReference<Backups>(new Backups());
        failReason = "";
        lastAutoBackup = 0L;
    }
}

