/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs.item.tool;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.rhino.mod.util.JsonUtils;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.mesdag.geckojs.GeckoJS;
import org.mesdag.geckojs.item.AbstractAnimatableItemBuilder;
import org.mesdag.geckojs.item.AnimatableItemRenderer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnimatableShieldItem
extends ShieldItem
implements GeoItem {
    private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Builder shieldItemBuilder;

    public AnimatableShieldItem(Builder shieldItemBuilder) {
        super(shieldItemBuilder.createItemProperties());
        this.shieldItemBuilder = shieldItemBuilder;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public int m_8105_(@NotNull ItemStack shield) {
        return this.shieldItemBuilder.useDuration == null ? super.m_8105_(shield) : this.shieldItemBuilder.useDuration.applyAsInt(shield);
    }

    public boolean m_6832_(@NotNull ItemStack shield, @NotNull ItemStack repairItem) {
        return this.shieldItemBuilder.validRepairItemCallback == null ? super.m_6832_(shield, repairItem) : this.shieldItemBuilder.validRepairItemCallback.is(shield, repairItem);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.shieldItemBuilder.usingAnimationCallback != null) {
                this.shieldItemBuilder.usingAnimationCallback.call(this, serverLevel, (ServerPlayer)player, hand);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.shieldItemBuilder.finishUsingAnimationCallback != null) {
                this.shieldItemBuilder.finishUsingAnimationCallback.call(this, serverLevel, livingEntity);
            }
        }
        return super.m_5922_(itemStack, level, livingEntity);
    }

    public void m_5551_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int tick) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.shieldItemBuilder.releaseUsingAnimationCallback != null) {
                this.shieldItemBuilder.releaseUsingAnimationCallback.call(this, serverLevel, livingEntity, tick);
            }
        }
        super.m_5551_(itemStack, level, livingEntity, tick);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private AnimatableItemRenderer<AnimatableShieldItem> renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    AnimatableItemRenderer itemRenderer = new AnimatableItemRenderer(AnimatableShieldItem.this.shieldItemBuilder.itemModel);
                    if (AnimatableShieldItem.this.shieldItemBuilder.useEntityGuiLighting) {
                        itemRenderer.useAlternateGuiLighting();
                    }
                    this.renderer = itemRenderer;
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        this.shieldItemBuilder.controllers.forEach(controller -> registrar.add(new AnimationController[]{controller.build(this)}));
        this.shieldItemBuilder.animations.forEach(animation -> {
            AnimationController[] animationControllerArray = new AnimationController[1];
            animationControllerArray[0] = new AnimationController((GeoAnimatable)this, animation::create);
            registrar.add(animationControllerArray);
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.CACHE;
    }

    public static class Builder
    extends AbstractAnimatableItemBuilder<AnimatableShieldItem> {
        private static final JsonObject shieldModel = (JsonObject)JsonUtils.GSON.fromJson("{\"parent\":\"geckojs:item/shield\",\"overrides\":[{\"predicate\":{\"blocking\":1},\"model\":\"geckojs:item/shield_blocking\"}]}", JsonObject.class);
        public ValidRepairItemCallback validRepairItemCallback;

        public Builder(ResourceLocation id) {
            super(id);
        }

        public Builder validRepairItem(ValidRepairItemCallback callback) {
            this.validRepairItemCallback = callback;
            return this;
        }

        @Override
        public void generateAssetJsons(AssetJsonGenerator generator) {
            ResourceLocation path = AssetJsonGenerator.asItemModelLocation((ResourceLocation)this.id);
            if (this.modelJson == null) {
                generator.json(path, (JsonElement)shieldModel);
            } else {
                generator.json(path, (JsonElement)this.modelJson);
            }
        }

        public AnimatableShieldItem createObject() {
            GeckoJS.REGISTERED_SHIELD.add(this.id);
            return new AnimatableShieldItem(this);
        }

        @HideFromJS
        public ItemBuilder parentModel(String m) {
            return super.parentModel(m);
        }

        @HideFromJS
        public ItemBuilder useAnimation(UseAnim animation) {
            return super.useAnimation(animation);
        }
    }

    @FunctionalInterface
    public static interface ValidRepairItemCallback {
        public boolean is(ItemStack var1, ItemStack var2);
    }
}

