/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import org.mesdag.geckojs.AnimationControllerBuilder;
import org.mesdag.geckojs.ExtendedGeoModel;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;

public abstract class AbstractAnimatableItemBuilder<T extends Item>
extends ItemBuilder {
    public final ExtendedGeoModel<T> itemModel = new ExtendedGeoModel();
    public UsingAnimationCallback usingAnimationCallback;
    public FinishUsingAnimationCallback finishUsingAnimationCallback;
    public ReleaseUsingAnimationCallback releaseUsingAnimationCallback;
    public final transient ArrayList<AnimationControllerBuilder<T>> controllers = new ArrayList();
    public final transient ArrayList<AnimationStateCallback> animations = new ArrayList();
    public transient boolean useEntityGuiLighting = false;

    public AbstractAnimatableItemBuilder(ResourceLocation id) {
        super(id);
    }

    public AbstractAnimatableItemBuilder<T> usingAnimation(UsingAnimationCallback callback) {
        this.usingAnimationCallback = callback;
        return this;
    }

    public AbstractAnimatableItemBuilder<T> finishUsingAnimation(FinishUsingAnimationCallback callback) {
        this.finishUsingAnimationCallback = callback;
        return this;
    }

    public AbstractAnimatableItemBuilder<T> releaseUsingAnimation(ReleaseUsingAnimationCallback callback) {
        this.releaseUsingAnimationCallback = callback;
        return this;
    }

    public AbstractAnimatableItemBuilder<T> addAnimation(AnimationStateCallback callBack) {
        this.animations.add(callBack);
        return this;
    }

    public AbstractAnimatableItemBuilder<T> addController(Consumer<AnimationControllerBuilder<T>> consumer) {
        AnimationControllerBuilder builder = new AnimationControllerBuilder();
        consumer.accept(builder);
        this.controllers.add(builder);
        return this;
    }

    public AbstractAnimatableItemBuilder<T> geoModel(Consumer<ExtendedGeoModel.Builder<T>> consumer) {
        consumer.accept(this.itemModel.builder);
        return this;
    }

    public AbstractAnimatableItemBuilder<T> defaultGeoModel() {
        this.itemModel.builder.setSimpleModel(new ResourceLocation(this.id.m_135827_(), "geo/item/" + this.id.m_135815_() + ".geo.json"));
        this.itemModel.builder.setSimpleTexture(new ResourceLocation(this.id.m_135827_(), "textures/item/" + this.id.m_135815_() + ".png"));
        this.itemModel.builder.setSimpleAnimation(new ResourceLocation(this.id.m_135827_(), "animations/item/" + this.id.m_135815_() + ".animation.json"));
        return this;
    }

    public AbstractAnimatableItemBuilder<T> useEntityGuiLighting() {
        this.useEntityGuiLighting = true;
        return this;
    }

    @HideFromJS
    public ItemBuilder texture(String key, String tex) {
        return super.texture(key, tex);
    }

    @HideFromJS
    public ItemBuilder texture(String tex) {
        return super.texture(tex);
    }

    @HideFromJS
    public ItemBuilder textureJson(JsonObject json) {
        return super.textureJson(json);
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
        if (this.modelJson == null) {
            generator.itemModel(this.id, model -> model.parent(this.parentModel.isEmpty() ? "geckojs:item/item" : this.parentModel));
        } else {
            generator.json(AssetJsonGenerator.asItemModelLocation((ResourceLocation)this.id), (JsonElement)this.modelJson);
        }
    }

    @FunctionalInterface
    public static interface UsingAnimationCallback {
        public void call(GeoItem var1, ServerLevel var2, ServerPlayer var3, InteractionHand var4);
    }

    @FunctionalInterface
    public static interface FinishUsingAnimationCallback {
        public void call(GeoItem var1, ServerLevel var2, LivingEntity var3);
    }

    @FunctionalInterface
    public static interface ReleaseUsingAnimationCallback {
        public void call(GeoItem var1, ServerLevel var2, LivingEntity var3, int var4);
    }

    @FunctionalInterface
    public static interface AnimationStateCallback {
        public PlayState create(AnimationState<GeoItem> var1);
    }
}

