/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs;

import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Hashtable;
import java.util.function.Function;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.EasingType;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class AnimationControllerBuilder<T extends GeoAnimatable> {
    private transient String name = "base_controller";
    private transient int transitionTickTime = 0;
    private transient AnimationController.AnimationStateHandler<T> animationStateHandler = state -> PlayState.STOP;
    private transient AnimationController.SoundKeyframeHandler<T> soundKeyframeHandler;
    private transient AnimationController.ParticleKeyframeHandler<T> particleKeyframeHandler;
    private transient AnimationController.CustomKeyframeHandler<T> customKeyframeHandler;
    private transient Function<T, Double> speedModFunction;
    private transient Function<T, EasingType> overrideEasingTypeFunction;
    private final transient Hashtable<String, RawAnimation> animations = new Hashtable();

    public AnimationControllerBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public AnimationControllerBuilder<T> transitionTickTime(int tick) {
        this.transitionTickTime = tick;
        return this;
    }

    public AnimationControllerBuilder<T> animationState(AnimationController.AnimationStateHandler<T> handler) {
        this.animationStateHandler = handler;
        return this;
    }

    @Info(value="Applies the given SoundKeyframeHandler to this controller, for handling sound keyframe instructions.")
    public AnimationControllerBuilder<T> soundKeyframe(AnimationController.SoundKeyframeHandler<T> handler) {
        this.soundKeyframeHandler = handler;
        return this;
    }

    @Info(value="Applies the given ParticleKeyframeHandler to this controller, for handling particle keyframe instructions.")
    public AnimationControllerBuilder<T> particleKeyframe(AnimationController.ParticleKeyframeHandler<T> handler) {
        this.particleKeyframeHandler = handler;
        return this;
    }

    @Info(value="Applies the given CustomKeyframeHandler to this controller, for handling sound keyframe instructions.")
    public AnimationControllerBuilder<T> customKeyframe(AnimationController.CustomKeyframeHandler<T> handler) {
        this.customKeyframeHandler = handler;
        return this;
    }

    @Info(value="Applies the given modifier function to this controller, for handling the speed that the controller should play its animations at.\n\nAn output value of 1 is considered neutral, with 2 playing an animation twice as fast, 0.5 playing half as fast, etc.\n\n@param speedModFunction The function to apply to this controller to handle animation speed\n")
    public AnimationControllerBuilder<T> animationSpeedHandler(Function<T, Double> function) {
        this.speedModFunction = function;
        return this;
    }

    @Info(value="Applies the given modifier value to this controller, for handling the speed that the controller should play its animations at.\n\nAn output value of 1 is considered neutral, with 2 playing an animation twice as fast, 0.5 playing half as fast, etc.\n\n@param speed The speed modifier to apply to this controller to handle animation speed.\n")
    public AnimationControllerBuilder<T> animationSpeed(double speed) {
        return this.animationSpeedHandler(animatable -> speed);
    }

    @Info(value="Sets the controller's EasingType override function for animations.\n\nBy default, the controller will use whatever EasingType was defined in the animation json\n\n@param easingType The new EasingType to use\n")
    public AnimationControllerBuilder<T> overrideEasingTypeFunction(Function<T, EasingType> function) {
        this.overrideEasingTypeFunction = function;
        return this;
    }

    @Info(value="Sets the controller's EasingType override for animations.\n\nBy default, the controller will use whatever EasingType was defined in the animation json\n\n@param easingTypeFunction The new EasingType to use\n")
    public AnimationControllerBuilder<T> overrideEasingType(EasingType easingType) {
        return this.overrideEasingTypeFunction(animatable -> easingType);
    }

    @Info(value="Registers a triggerable RawAnimation with the controller.\n\nThese can then be triggered by the various triggerAnim methods in GeoAnimatable's subclasses\n\n@param name The name of the triggerable animation\n\n@param animation The RawAnimation for this triggerable animation\n")
    public AnimationControllerBuilder<T> triggerableAnim(String animName, RawAnimation animation) {
        this.animations.put(animName, animation);
        return this;
    }

    @HideFromJS
    public AnimationController<T> build(T animatable) {
        AnimationController controller = new AnimationController(animatable, this.name, this.transitionTickTime, this.animationStateHandler);
        if (this.soundKeyframeHandler != null) {
            controller.setSoundKeyframeHandler(this.soundKeyframeHandler);
        }
        if (this.particleKeyframeHandler != null) {
            controller.setParticleKeyframeHandler(this.particleKeyframeHandler);
        }
        if (this.customKeyframeHandler != null) {
            controller.setCustomInstructionKeyframeHandler(this.customKeyframeHandler);
        }
        if (this.speedModFunction != null) {
            controller.setAnimationSpeedHandler(this.speedModFunction);
        }
        if (this.overrideEasingTypeFunction != null) {
            controller.setOverrideEasingTypeFunction(this.overrideEasingTypeFunction);
        }
        this.animations.forEach((arg_0, arg_1) -> ((AnimationController)controller).triggerableAnim(arg_0, arg_1));
        return controller;
    }
}

