/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class MincerRecipe
implements Recipe<Container> {
    final ResourceLocation id;
    private final String recipe_type;
    private final Ingredient input;
    private final ItemStack output;

    public MincerRecipe(ResourceLocation id, String type, Ingredient input, ItemStack output) {
        this.id = id;
        this.recipe_type = type;
        this.input = input;
        this.output = output;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)this.input);
        return nonNullList;
    }

    public String getRecipeType() {
        return this.recipe_type;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return this.input.test(inventory.m_8020_(0));
    }

    @NotNull
    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistry.MINCER_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.MINCER_RECIPE_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<MincerRecipe> {
        @NotNull
        public MincerRecipe fromJson(ResourceLocation id, JsonObject json) {
            String recipe_type = GsonHelper.m_13906_((JsonObject)json, (String)"recipe_type");
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new MincerRecipe(id, recipe_type, input, output);
        }

        @NotNull
        public MincerRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            String recipe_type = buf.m_130277_();
            return new MincerRecipe(id, recipe_type, input, output);
        }

        public void toNetwork(FriendlyByteBuf buf, MincerRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.m_130055_(recipe.output);
            buf.m_130070_(recipe.recipe_type);
        }
    }
}

