/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.cristelknight.doapi.common.util.GeneralUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class CraftingBowlRecipe
implements Recipe<Container> {
    final ResourceLocation id;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int outputCount;

    public CraftingBowlRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output, int outputCount) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.outputCount = outputCount;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public boolean m_5818_(Container inventory, Level world) {
        int nonEmptySlots = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            ++nonEmptySlots;
        }
        return nonEmptySlots >= 1 && nonEmptySlots <= this.inputs.size() && GeneralUtil.matchesRecipe((Container)inventory, this.inputs, (int)0, (int)3);
    }

    @NotNull
    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        ItemStack result = this.output.m_41777_();
        result.m_41764_(this.outputCount);
        return result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistry.CRAFTING_BOWL_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.CRAFTING_BOWL_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<CraftingBowlRecipe> {
        @NotNull
        public CraftingBowlRecipe fromJson(ResourceLocation id, JsonObject json) {
            NonNullList ingredients = GeneralUtil.deserializeIngredients((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            JsonObject resultJson = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)resultJson);
            int count = GsonHelper.m_13824_((JsonObject)resultJson, (String)"count", (int)1);
            return new CraftingBowlRecipe(id, (NonNullList<Ingredient>)ingredients, result, count);
        }

        @NotNull
        public CraftingBowlRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int ingredientCount = buf.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            int count = buf.m_130242_();
            return new CraftingBowlRecipe(id, (NonNullList<Ingredient>)ingredients, result, count);
        }

        public void toNetwork(FriendlyByteBuf buf, CraftingBowlRecipe recipe) {
            buf.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(ingredient -> ingredient.m_43923_(buf));
            buf.m_130055_(recipe.output);
            buf.m_130130_(recipe.outputCount);
        }
    }
}

