/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.entity;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.entity.CartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChestCart
extends CartEntity
implements HasCustomInventoryScreen,
ContainerEntity {
    private static final int CONTAINER_SIZE = 27;
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;

    public ChestCart(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected float firstPoint() {
        return 3.0f;
    }

    @Override
    protected float lastPoint() {
        return 1.0f;
    }

    @Override
    protected float wheelRadius() {
        return 1.0f;
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand interactionHand) {
        if (player.m_36341_()) {
            return super.m_6096_(player, interactionHand);
        }
        if (this.m_7310_((Entity)player)) {
            if (!this.m_9236_().m_5776_()) {
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = this.m_268996_(player);
        if (interactionResult.m_19077_()) {
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return interactionResult;
    }

    @Override
    public void destroy(DamageSource damageSource) {
        super.destroy(damageSource);
        this.m_219927_(damageSource, this.m_9236_(), this);
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (!this.m_9236_().f_46443_ && removalReason.m_146965_()) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(removalReason);
    }

    public void m_213583_(Player player) {
        player.m_5893_((MenuProvider)this);
        if (!player.m_9236_().f_46443_) {
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    public void m_6211_() {
        this.m_219953_();
    }

    public int m_6643_() {
        return 27;
    }

    @NotNull
    public ItemStack m_8020_(int i) {
        return this.m_219947_(i);
    }

    @NotNull
    public ItemStack m_7407_(int i, int j) {
        return this.m_219936_(i, j);
    }

    @NotNull
    public ItemStack m_8016_(int i) {
        return this.m_219945_(i);
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.m_219940_(i, itemStack);
    }

    @NotNull
    public SlotAccess m_141942_(int i) {
        return this.m_219951_(i);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return this.m_219954_(player);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        if (null != this.lootTable && player.m_5833_()) {
            return null;
        }
        this.unpackLootTable(inventory.f_35978_);
        return ChestMenu.m_39237_((int)i, (Inventory)inventory, (Container)this);
    }

    public void unpackLootTable(@Nullable Player player) {
        this.m_219949_(player);
    }

    @Nullable
    public ResourceLocation m_214142_() {
        return this.lootTable;
    }

    public void m_214199_(@Nullable ResourceLocation resourceLocation) {
        this.lootTable = resourceLocation;
    }

    public long m_213803_() {
        return this.lootTableSeed;
    }

    public void m_214065_(long l) {
        this.lootTableSeed = l;
    }

    @NotNull
    public NonNullList<ItemStack> m_213659_() {
        return this.inventory;
    }

    public void m_213775_() {
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public void m_5785_(Player player) {
        this.m_9236_().m_214171_(GameEvent.f_157802_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)player));
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.m_219943_(compoundTag);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.m_219934_(compoundTag);
    }

    public double m_6048_() {
        return super.m_6048_() + (double)this.m_146909_();
    }

    protected double getPassengerXOffset(Entity entity) {
        if (this.m_20197_().size() > 1 && this.m_20197_().indexOf(entity) > 0) {
            return -1.0;
        }
        return 1.0;
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() < this.getMaxPassengers() && super.m_7310_(entity);
    }

    protected int getMaxPassengers() {
        return 2;
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            double x = this.getPassengerXOffset(entity);
            double y = this.m_6048_() + entity.m_6049_();
            Vec3 xVec = new Vec3(x, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            Vec3 yVec = new Vec3(0.0, y, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180) - 1.5707964f);
            moveFunction.m_20372_(entity, this.m_20185_() + xVec.f_82479_, this.m_20186_() + yVec.f_82480_, this.m_20189_() + xVec.f_82481_);
        }
    }
}

