/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.block;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.block.entity.WaterSprinklerBlockEntity;
import org.jetbrains.annotations.NotNull;

public class WaterSprinklerBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.0625, (double)0.125, (double)0.75, (double)0.9375), Shapes.m_83048_((double)0.875, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.75, (double)0.9375), Shapes.m_83048_((double)0.125, (double)0.0625, (double)0.0625, (double)0.875, (double)0.75, (double)0.125), Shapes.m_83048_((double)0.125, (double)0.0625, (double)0.875, (double)0.875, (double)0.75, (double)0.9375), Shapes.m_83048_((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)1.0625, (double)0.5625)});

    public WaterSprinklerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.m_186460_(pos, (Block)this, 1);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!world.m_46471_() && !world.m_46470_()) {
            BlockEntity blockEntity;
            super.m_214162_(state, world, pos, random);
            if (world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof WaterSprinklerBlockEntity) {
                WaterSprinklerBlockEntity sprinklerBlockEntity = (WaterSprinklerBlockEntity)blockEntity;
                float angle = sprinklerBlockEntity.getRotationAngle();
                double x = (double)pos.m_123341_() + 0.5;
                double y = (double)pos.m_123342_() + 1.0;
                double z = (double)pos.m_123343_() + 0.5;
                double velocity = 0.2;
                double startOffset = 0.5;
                for (int i = 0; i < 4; ++i) {
                    double angleRadians = Math.toRadians(angle + (float)(90 * i));
                    double cos = Math.cos(angleRadians);
                    double sin = Math.sin(angleRadians);
                    double dx = cos * velocity;
                    double dz = sin * velocity;
                    double startX = x + cos * startOffset;
                    double startZ = z + sin * startOffset;
                    for (double length = 0.0; length < 3.0; length += 0.5) {
                        double currentX = startX + dx * length;
                        double currentZ = startZ + dz * length;
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123769_, currentX, y, currentZ, dx, 0.0, dz);
                    }
                }
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, -1, -4), (BlockPos)pos.m_7918_(4, 1, 4)).forEach(blockPos -> {
            BlockState blockState = world.m_8055_(blockPos);
            if (blockState.m_60713_(Blocks.f_50083_)) {
                world.m_7471_(blockPos, false);
                world.m_5594_(null, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (random.m_188501_() - random.m_188501_()) * 0.8f);
            }
        });
        world.m_186460_(pos, (Block)this, 20);
        this.playContinuousSound(world, pos);
    }

    private void playContinuousSound(ServerLevel world, BlockPos pos) {
        world.m_5594_(null, pos, (SoundEvent)DoApiSoundEventRegistry.WATER_SPRINKLER.get(), SoundSource.BLOCKS, 0.25f, 0.75f);
        world.m_186460_(pos, (Block)this, 80);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WaterSprinklerBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

