/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.data.server;

import com.teamabnormals.blueprint.core.other.tags.BlueprintItemTags;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class BlueprintRecipeProvider
extends RecipeProvider {
    private final String modid;

    public BlueprintRecipeProvider(String modid, PackOutput output) {
        super(output);
        this.modid = modid;
    }

    public void m_245200_(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Blocks.f_50145_).m_206416_(Character.valueOf('A'), BlueprintItemTags.BUCKETS_MILK).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42405_).m_206416_(Character.valueOf('E'), Tags.Items.EGGS).m_126130_("AAA").m_126130_("BEB").m_126130_("CCC").m_126132_("has_egg", (CriterionTriggerInstance)BlueprintRecipeProvider.m_206406_((TagKey)Tags.Items.EGGS)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.f_42687_).m_206419_(BlueprintItemTags.PUMPKINS).m_126209_((ItemLike)Items.f_42501_).m_206419_(Tags.Items.EGGS).m_126132_("has_carved_pumpkin", (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)Blocks.f_50143_)).m_126132_("has_pumpkin", (CriterionTriggerInstance)BlueprintRecipeProvider.m_206406_(BlueprintItemTags.PUMPKINS)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.f_42577_, (int)4).m_206419_(BlueprintItemTags.PUMPKINS).m_126132_("has_pumpkin", (CriterionTriggerInstance)BlueprintRecipeProvider.m_206406_(BlueprintItemTags.PUMPKINS)).m_176498_(consumer);
    }

    public static void foodCookingRecipes(Consumer<FinishedRecipe> consumer, ItemLike input, ItemLike output) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)0.35f, (int)200).m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)input)).m_176498_(consumer);
        SimpleCookingRecipeBuilder.m_246159_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)0.35f, (int)100).m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)input)).m_176500_(consumer, RecipeBuilder.m_176493_((ItemLike)output) + "_from_smoking");
        SimpleCookingRecipeBuilder.m_247020_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)0.35f, (int)600).m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)input)).m_176500_(consumer, RecipeBuilder.m_176493_((ItemLike)output) + "_from_campfire_cooking");
    }

    public void oreRecipes(Consumer<FinishedRecipe> consumer, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float smeltingXp, int smeltingTime, String group) {
        this.oreRecipes(consumer, inputs, category, output, smeltingXp, smeltingTime, smeltingXp, smeltingTime / 2, group);
    }

    public void oreRecipes(Consumer<FinishedRecipe> consumer, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float smeltingXp, int smeltingTime, float blastingXp, int blastingTime, String group) {
        this.smeltingRecipe(consumer, inputs, category, output, smeltingXp, smeltingTime, group);
        this.blastingRecipe(consumer, inputs, category, output, blastingXp, blastingTime, group);
    }

    public void smeltingRecipe(Consumer<FinishedRecipe> consumer, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float xp, int cookTime, String group) {
        this.oreRecipe(consumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_, inputs, category, output, xp, cookTime, group, "_from_smelting");
    }

    public void blastingRecipe(Consumer<FinishedRecipe> consumer, List<ItemLike> p_176627_, RecipeCategory category, ItemLike output, float xp, int cookTime, String group) {
        this.oreRecipe(consumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_, p_176627_, category, output, xp, cookTime, group, "_from_blasting");
    }

    public void oreRecipe(Consumer<FinishedRecipe> consumer, RecipeSerializer<? extends AbstractCookingRecipe> recipeSerializer, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float xp, int cookTime, String p_176540_, String suffix) {
        for (ItemLike itemlike : inputs) {
            SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)category, (ItemLike)output, (float)xp, (int)cookTime, recipeSerializer).m_126145_(p_176540_).m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)itemlike), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)itemlike)).m_126140_(consumer, new ResourceLocation(this.modid, BlueprintRecipeProvider.m_176632_((ItemLike)output) + suffix + "_" + BlueprintRecipeProvider.m_176632_((ItemLike)itemlike)));
        }
    }

    public void leafPileRecipes(Consumer<FinishedRecipe> consumer, ItemLike leaves, ItemLike leafPile) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)leafPile, (int)4).m_126209_(leaves).m_126145_("leaf_pile").m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)leaves), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)leaves)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)leaves).m_126127_(Character.valueOf('#'), leafPile).m_126130_("##").m_126130_("##").m_126145_("leaves").m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)leafPile), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)leafPile)).m_126140_(consumer, this.getModConversionRecipeName(leaves, leafPile));
    }

    public void stonecutterRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, ItemLike output, ItemLike input) {
        this.stonecutterRecipe(consumer, category, output, input, 1);
    }

    public void stonecutterRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, ItemLike output, ItemLike input, int count) {
        SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)output, (int)count).m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)input)).m_176500_(consumer, this.getModConversionRecipeName(output, input) + "_stonecutting");
    }

    public void conversionRecipe(Consumer<FinishedRecipe> consumer, ItemLike output, ItemLike input, @Nullable String group) {
        this.conversionRecipe(consumer, output, input, group, 1);
    }

    public void conversionRecipe(Consumer<FinishedRecipe> consumer, ItemLike output, ItemLike input, @Nullable String group, int count) {
        BlueprintRecipeProvider.conversionRecipeBuilder(output, input, count).m_126145_(group).m_126140_(consumer, this.getModConversionRecipeName(output, input));
    }

    public static ShapelessRecipeBuilder conversionRecipeBuilder(ItemLike output, ItemLike input, int count) {
        return BlueprintRecipeProvider.conversionRecipeBuilder(RecipeCategory.MISC, output, input, count);
    }

    public static ShapelessRecipeBuilder conversionRecipeBuilder(RecipeCategory category, ItemLike output, ItemLike input, int count) {
        return ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)output, (int)count).m_126209_(input).m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)input));
    }

    public void storageRecipes(Consumer<FinishedRecipe> consumer, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage, String storageName, String storageGroup, String itemName, String itemGroup) {
        BlueprintRecipeProvider.m_247368_(consumer, (RecipeCategory)itemCategory, (ItemLike)item, (RecipeCategory)storageCategory, (ItemLike)storage, (String)(this.modid + ":" + storageName), (String)storageGroup, (String)(this.modid + ":" + itemName), (String)itemGroup);
    }

    public void storageRecipes(Consumer<FinishedRecipe> consumer, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage) {
        this.storageRecipes(consumer, itemCategory, item, storageCategory, storage, BlueprintRecipeProvider.m_176644_((ItemLike)storage), null, BlueprintRecipeProvider.m_176644_((ItemLike)item), null);
    }

    public void storageRecipesWithCustomPacking(Consumer<FinishedRecipe> consumer, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage, String storageName, String storageGroup) {
        this.storageRecipes(consumer, itemCategory, item, storageCategory, storage, storageName, storageGroup, BlueprintRecipeProvider.m_176644_((ItemLike)item), null);
    }

    public void storageRecipesWithCustomUnpacking(Consumer<FinishedRecipe> consumer, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage, String itemName, String itemGroup) {
        this.storageRecipes(consumer, itemCategory, item, storageCategory, storage, BlueprintRecipeProvider.m_176644_((ItemLike)storage), null, itemName, itemGroup);
    }

    public void conditionalStorageRecipes(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage) {
        this.conditionalStorageRecipes(consumer, condition, itemCategory, item, storageCategory, storage, BlueprintRecipeProvider.m_176644_((ItemLike)storage), null, BlueprintRecipeProvider.m_176644_((ItemLike)item), null);
    }

    public void conditionalStorageRecipes(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage, String storageLocation, @Nullable String itemGroup, String itemLocation, @Nullable String storageGroup) {
        BlueprintRecipeProvider.conditionalRecipe(consumer, condition, itemCategory, (RecipeBuilder)ShapelessRecipeBuilder.m_246517_((RecipeCategory)itemCategory, (ItemLike)item, (int)9).m_126209_(storage).m_126145_(storageGroup).m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)storage), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)storage)), new ResourceLocation(this.modid, itemLocation));
        BlueprintRecipeProvider.conditionalRecipe(consumer, condition, storageCategory, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)storageCategory, (ItemLike)storage).m_126127_(Character.valueOf('#'), item).m_126130_("###").m_126130_("###").m_126130_("###").m_126145_(itemGroup).m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)item), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)item)), new ResourceLocation(this.modid, storageLocation));
    }

    public void conditionalStorageRecipesWithCustomUnpacking(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage, String shapelessName, String shapelessGroup) {
        this.conditionalStorageRecipes(consumer, condition, itemCategory, item, storageCategory, storage, BlueprintRecipeProvider.m_176644_((ItemLike)storage), null, shapelessName, shapelessGroup);
    }

    public static void conditionalRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory category, RecipeBuilder recipe) {
        BlueprintRecipeProvider.conditionalRecipe(consumer, condition, category, recipe, RecipeBuilder.m_176493_((ItemLike)recipe.m_142372_()));
    }

    public static void conditionalRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory category, RecipeBuilder recipe, ResourceLocation id) {
        ConditionalRecipe.builder().addCondition(condition).addRecipe(consumer1 -> recipe.m_126140_(consumer1, id)).generateAdvancement(new ResourceLocation(id.m_135827_(), "recipes/" + category.m_247710_() + "/" + id.m_135815_())).build(consumer, id);
    }

    public void waxRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, ItemLike input, ItemLike result) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)category, (ItemLike)result).m_126209_(input).m_126209_((ItemLike)Items.f_42784_).m_126145_(BlueprintRecipeProvider.m_176632_((ItemLike)result)).m_126132_(BlueprintRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)input)).m_126140_(consumer, this.getModConversionRecipeName(result, (ItemLike)Items.f_42784_));
    }

    public void netheriteSmithingRecipe(Consumer<FinishedRecipe> consumer, Item input, RecipeCategory category, Item output) {
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), (RecipeCategory)category, (Item)output).m_266439_("has_netherite_ingot", (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)Items.f_42418_)).m_266371_(consumer, new ResourceLocation(this.modid, BlueprintRecipeProvider.m_176632_((ItemLike)output) + "_smithing"));
    }

    public static void trimSmithing(Consumer<FinishedRecipe> consumer, ItemLike item) {
        SmithingTrimRecipeBuilder.m_266182_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), (Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_265942_), (Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_265843_), (RecipeCategory)RecipeCategory.MISC).m_266331_("has_smithing_trim_template", (CriterionTriggerInstance)BlueprintRecipeProvider.m_125977_((ItemLike)item)).m_266403_(consumer, BlueprintRecipeProvider.suffix(RecipeBuilder.m_176493_((ItemLike)item), "_smithing_trim"));
    }

    public static void trimRecipes(Consumer<FinishedRecipe> consumer, ItemLike item, TagKey<Item> copyItem) {
        BlueprintRecipeProvider.trimSmithing(consumer, item);
        BlueprintRecipeProvider.m_266564_(consumer, (ItemLike)item, copyItem);
    }

    public static void trimRecipes(Consumer<FinishedRecipe> consumer, ItemLike item, ItemLike copyItem) {
        BlueprintRecipeProvider.trimSmithing(consumer, item);
        BlueprintRecipeProvider.m_266438_(consumer, (ItemLike)item, (ItemLike)copyItem);
    }

    public static ResourceLocation suffix(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    public ResourceLocation getModConversionRecipeName(ItemLike output, ItemLike input) {
        return new ResourceLocation(this.modid, BlueprintRecipeProvider.m_176517_((ItemLike)output, (ItemLike)input));
    }

    public String getModID() {
        return this.modid;
    }
}

