/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.block.ITrim;
import com.tom.storagemod.tile.AbstractInventoryCableConnectorBlockEntity;
import com.tom.storagemod.tile.InventoryProxyBlockEntity;
import com.tom.storagemod.util.IProxy;
import com.tom.storagemod.util.InfoHandler;
import com.tom.storagemod.util.InventoryConnectorConfigUtil;
import com.tom.storagemod.util.MultiItemHandler;
import com.tom.storagemod.util.Priority;
import com.tom.storagemod.util.TickerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class InventoryConnectorBlockEntity
extends BlockEntity
implements TickerUtil.TickableServer {
    private MultiItemHandler handlers = new MultiItemHandler();
    private List<LinkedInv> linkedInvs = new ArrayList<LinkedInv>();
    private LazyOptional<IItemHandler> invHandler = LazyOptional.of(() -> this.handlers);

    public InventoryConnectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.connectorTile.get(), pos, state);
    }

    @Override
    public void updateServer() {
        long time = this.f_58857_.m_46467_();
        if (time % 20L == 0L) {
            Stack<BlockPos> toCheck = new Stack<BlockPos>();
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            toCheck.add(this.f_58858_);
            checkedBlocks.add(this.f_58858_);
            this.handlers.clear();
            HashSet<LinkedInv> toRM = new HashSet<LinkedInv>();
            Collections.sort(this.linkedInvs);
            for (LinkedInv inv : this.linkedInvs) {
                MultiItemHandler ih;
                if (inv.time + 40L < time) {
                    toRM.add(inv);
                    continue;
                }
                LazyOptional<IItemHandler> i = inv.handler.get();
                if (!i.isPresent()) continue;
                IItemHandler blockHandler = (IItemHandler)i.orElse(null);
                IItemHandler ihr = IProxy.resolve(blockHandler);
                if (ihr instanceof MultiItemHandler && this.checkHandlers(ih = (MultiItemHandler)ihr, 0)) {
                    if (this.handlers.contains(InfoHandler.INSTANCE)) continue;
                    this.handlers.add(InfoHandler.INSTANCE);
                    continue;
                }
                this.handlers.add(i);
            }
            this.linkedInvs.removeAll(toRM);
            while (!toCheck.isEmpty()) {
                BlockPos cp = (BlockPos)toCheck.pop();
                for (Direction d : Direction.values()) {
                    ChestType type;
                    Block block;
                    BlockEntity te;
                    BlockPos p = cp.m_121945_(d);
                    if (checkedBlocks.contains(p) || !(p.m_123331_((Vec3i)this.f_58858_) < (double)Config.get().invRange)) continue;
                    checkedBlocks.add(p);
                    BlockState state = this.f_58857_.m_8055_(p);
                    if (state.m_60734_() instanceof ITrim) {
                        toCheck.add(p);
                        continue;
                    }
                    if (!InventoryConnectorConfigUtil.canConnect(state.m_60734_()) || (te = this.f_58857_.m_7702_(p)) instanceof InventoryConnectorBlockEntity || te instanceof InventoryProxyBlockEntity || te instanceof AbstractInventoryCableConnectorBlockEntity || te == null || Config.get().onlyTrims) continue;
                    LazyOptional inv = te.getCapability(ForgeCapabilities.ITEM_HANDLER, d.m_122424_());
                    if (te instanceof ChestBlockEntity && (block = state.m_60734_()) instanceof ChestBlock && (type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_)) != ChestType.SINGLE) {
                        ChestType otype;
                        BlockPos opos = p.m_121945_(ChestBlock.m_51584_((BlockState)state));
                        BlockState ostate = this.m_58904_().m_8055_(opos);
                        if (state.m_60734_() == ostate.m_60734_() && (otype = (ChestType)ostate.m_61143_((Property)ChestBlock.f_51479_)) != ChestType.SINGLE && type != otype && state.m_61143_((Property)ChestBlock.f_51478_) == ostate.m_61143_((Property)ChestBlock.f_51478_)) {
                            toCheck.add(opos);
                            checkedBlocks.add(opos);
                        }
                    }
                    if (inv.isPresent()) {
                        MultiItemHandler ih;
                        IItemHandler ihr;
                        IItemHandler blockHandler = (IItemHandler)inv.orElse(null);
                        if (blockHandler == null) {
                            StorageMod.LOGGER.warn("Broken modded block at " + p + " in " + this.f_58857_.m_46472_().m_135782_().toString() + " block id: " + ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString());
                        }
                        if ((ihr = IProxy.resolve(blockHandler)) instanceof MultiItemHandler && this.checkHandlers(ih = (MultiItemHandler)ihr, 0)) {
                            if (this.handlers.contains(InfoHandler.INSTANCE)) continue;
                            this.handlers.add(InfoHandler.INSTANCE);
                            continue;
                        }
                        toCheck.add(p);
                        this.handlers.add((LazyOptional<IItemHandler>)inv);
                    }
                    if (!Config.get().multiblockInvs.contains(state.m_60734_())) continue;
                    this.skipBlocks(p, checkedBlocks, toCheck, state.m_60734_());
                }
            }
            this.handlers.refresh();
        }
    }

    private void skipBlocks(BlockPos pos, Set<BlockPos> checkedBlocks, Stack<BlockPos> edges, Block block) {
        Stack<BlockPos> toCheck = new Stack<BlockPos>();
        toCheck.add(pos);
        edges.add(pos);
        while (!toCheck.isEmpty()) {
            BlockPos cp = (BlockPos)toCheck.pop();
            for (Direction d : Direction.values()) {
                BlockState state;
                BlockPos p = cp.m_121945_(d);
                if (checkedBlocks.contains(p) || !(p.m_123331_((Vec3i)this.f_58858_) < (double)Config.get().invRange) || (state = this.f_58857_.m_8055_(p)).m_60734_() != block) continue;
                checkedBlocks.add(p);
                edges.add(p);
                toCheck.add(p);
            }
        }
    }

    private boolean checkHandlers(MultiItemHandler ih, int depth) {
        if (depth > 3) {
            return true;
        }
        for (LazyOptional<IItemHandler> lo : ih.getHandlers()) {
            IItemHandler ihr = IProxy.resolve((IItemHandler)lo.orElse(null));
            if (ihr == this.handlers) {
                return true;
            }
            if (!(ihr instanceof MultiItemHandler) || !this.checkHandlers((MultiItemHandler)ihr, depth + 1)) continue;
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getInventory().cast();
        }
        return super.getCapability(cap, side);
    }

    public LazyOptional<IItemHandler> getInventory() {
        return this.invHandler;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    public void addLinked(LinkedInv inv) {
        this.linkedInvs.add(inv);
    }

    public void unLink(LinkedInv linv) {
        this.linkedInvs.remove(linv);
    }

    private int getFreeSlotCount() {
        return (Integer)this.getInventory().lazyMap(inv -> {
            int empty = 0;
            for (int i = 0; i < this.handlers.getSlots(); ++i) {
                if (!inv.getStackInSlot(i).m_41619_()) continue;
                ++empty;
            }
            return empty;
        }).orElse((Object)0);
    }

    public Tuple<Integer, Integer> getUsage() {
        return new Tuple((Object)this.handlers.getSlots(), (Object)this.getFreeSlotCount());
    }

    public static class LinkedInv
    implements Comparable<LinkedInv> {
        public Supplier<LazyOptional<IItemHandler>> handler;
        public long time;
        public Priority priority = Priority.NORMAL;

        @Override
        public int compareTo(LinkedInv o) {
            return -this.priority.compareTo(o.priority);
        }
    }
}

