/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.integration.jei;

import com.teamabnormals.autumnity.core.other.AutumnityTiers;
import com.teamabnormals.autumnity.core.registry.AutumnityItems;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class AutumnityPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("autumnity", "autumnity");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.ANVIL, AutumnityPlugin.getRepairRecipes(registration.getVanillaRecipeFactory()).toList());
    }

    private static Stream<RepairData> getRepairData() {
        return Stream.of(new RepairData(AutumnityTiers.SNAIL_SHELL.m_6230_(), new ItemStack((ItemLike)AutumnityItems.SNAIL_SHELL_CHESTPLATE.get())));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        return AutumnityPlugin.getRepairData().flatMap(repairData -> AutumnityPlugin.getRepairRecipes(repairData, vanillaRecipeFactory));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(RepairData repairData, IVanillaRecipeFactory vanillaRecipeFactory) {
        Ingredient repairIngredient = repairData.getRepairIngredient();
        List<ItemStack> repairables = repairData.getRepairables();
        List<ItemStack> repairMaterials = List.of(repairIngredient.m_43908_());
        return repairables.stream().mapMulti((itemStack, consumer) -> {
            ItemStack damagedThreeQuarters = itemStack.m_41777_();
            damagedThreeQuarters.m_41721_(damagedThreeQuarters.m_41776_() * 3 / 4);
            ItemStack damagedHalf = itemStack.m_41777_();
            damagedHalf.m_41721_(damagedHalf.m_41776_() / 2);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedThreeQuarters), List.of(damagedThreeQuarters), List.of(damagedHalf));
            consumer.accept(repairWithSame);
            if (!repairMaterials.isEmpty()) {
                ItemStack damagedFully = itemStack.m_41777_();
                damagedFully.m_41721_(damagedFully.m_41776_());
                IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damagedThreeQuarters));
                consumer.accept(repairWithMaterial);
            }
        });
    }

    private static class RepairData {
        private final Ingredient repairIngredient;
        private final List<ItemStack> repairables;

        public RepairData(Ingredient repairIngredient, ItemStack ... repairables) {
            this.repairIngredient = repairIngredient;
            this.repairables = List.of(repairables);
        }

        public Ingredient getRepairIngredient() {
            return this.repairIngredient;
        }

        public List<ItemStack> getRepairables() {
            return this.repairables;
        }
    }
}

