/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.network.handler;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.data.ExposureLook;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.data.storage.ServersideExposureExporter;
import io.github.mortuusars.exposure_catalog.network.packet.server.ExportExposuresC2SP;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;

public class ServerPacketsHandler {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicBoolean isExporting = new AtomicBoolean(false);
    private static final AtomicInteger exportedCount = new AtomicInteger(0);
    private static final Map<ServerPlayer, List<String>> exportData = new HashMap<ServerPlayer, List<String>>();

    public static void handleExport(ServerPlayer player, ExportExposuresC2SP packet) {
        List<String> exposureIds;
        if (packet.partIndex() == 0) {
            exportData.put(player, new ArrayList());
        }
        Preconditions.checkState(((exposureIds = exportData.get(player)) != null ? 1 : 0) != 0, (Object)"Invalid export data. Packets received out of order or the first packet haven't been received.");
        exposureIds.addAll(packet.exposureIds());
        if (packet.isLastPart()) {
            if (isExporting.get()) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.exposure_catalog.export.already_exporting"), false);
                return;
            }
            if (exposureIds.isEmpty()) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.exposure_catalog.export.nothing_to_export"), false);
                return;
            }
            player.m_5661_((Component)Component.m_237110_((String)"gui.exposure_catalog.export.exporting_count", (Object[])new Object[]{exposureIds.size()}), false);
            ServerPacketsHandler.exportExposuresChunk(player, exposureIds, packet.size(), packet.look());
        }
    }

    private static void exportExposuresChunk(ServerPlayer player, List<String> exposureIds, ExposureSize size, ExposureLook look) {
        isExporting.set(true);
        exportedCount.set(0);
        List chunks = Lists.partition(exposureIds, (int)2500);
        new Thread(() -> {
            try {
                File folder = Objects.requireNonNull(player.m_9236_().m_7654_()).m_129843_(LevelResource.f_78182_).resolve("exposures").toFile();
                boolean ignored = folder.mkdirs();
                ArrayList<Thread> threads = new ArrayList<Thread>();
                for (List chunk : chunks) {
                    Thread thread = new Thread(() -> ServerPacketsHandler.exportExposuresChunk(chunk, folder, size, look));
                    threads.add(thread);
                    thread.start();
                }
                for (Thread thread : threads) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.toString());
                    }
                }
                LOGGER.info("Exported {} exposures.", (Object)exportedCount.get());
                player.m_5661_((Component)Component.m_237110_((String)"gui.exposure_catalog.export.exported", (Object[])new Object[]{exportedCount.get()}), false);
                isExporting.set(false);
                exportedCount.set(0);
            }
            catch (Exception e) {
                LOGGER.error("Exporting exposures failed: " + e);
                player.m_5661_((Component)Component.m_237115_((String)"gui.exposure_catalog.export.error_occurred"), false);
            }
        }).start();
    }

    private static void exportExposuresChunk(List<String> chunk, File folder, ExposureSize size, ExposureLook look) {
        for (String exposureId : chunk) {
            Optional data = ExposureServer.getExposureStorage().getOrQuery(exposureId);
            if (data.isEmpty()) {
                LOGGER.error("Exposure '" + exposureId + "' is not found.");
                continue;
            }
            ExposureSavedData exposureSavedData = (ExposureSavedData)data.get();
            String name = exposureId + look.getIdSuffix();
            boolean saved = ((ServersideExposureExporter)((ServersideExposureExporter)((ServersideExposureExporter)new ServersideExposureExporter(name).withFolder(folder.getAbsolutePath())).withModifier(look.getModifier())).withSize(size)).save(exposureSavedData);
            if (!saved) continue;
            exportedCount.incrementAndGet();
        }
    }
}

