/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.network.forge;

import io.github.mortuusars.exposure_catalog.ExposureCatalog;
import io.github.mortuusars.exposure_catalog.network.PacketDirection;
import io.github.mortuusars.exposure_catalog.network.packet.IPacket;
import io.github.mortuusars.exposure_catalog.network.packet.client.OpenCatalogS2CP;
import io.github.mortuusars.exposure_catalog.network.packet.client.SendExposureThumbnailS2CP;
import io.github.mortuusars.exposure_catalog.network.packet.client.SendExposuresDataPartS2CP;
import io.github.mortuusars.exposure_catalog.network.packet.server.CatalogClosedC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.server.DeleteExposureC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.server.ExportExposuresC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.server.QueryExposuresC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.server.QueryThumbnailC2SP;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketsImpl {
    private static final String PROTOCOL_VERSION = "1";
    private static int id = 0;
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)ExposureCatalog.resource("packets"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        CHANNEL.messageBuilder(QueryExposuresC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(QueryExposuresC2SP::toBuffer).decoder(QueryExposuresC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(DeleteExposureC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(DeleteExposureC2SP::toBuffer).decoder(DeleteExposureC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(ExportExposuresC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(ExportExposuresC2SP::toBuffer).decoder(ExportExposuresC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(QueryThumbnailC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(QueryThumbnailC2SP::toBuffer).decoder(QueryThumbnailC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(CatalogClosedC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(IPacket::toBuffer).decoder(CatalogClosedC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(OpenCatalogS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(IPacket::toBuffer).decoder(OpenCatalogS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(SendExposuresDataPartS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(SendExposuresDataPartS2CP::toBuffer).decoder(SendExposuresDataPartS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(SendExposureThumbnailS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(SendExposureThumbnailS2CP::toBuffer).decoder(SendExposureThumbnailS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
    }

    public static void sendToServer(IPacket packet) {
        CHANNEL.sendToServer((Object)packet);
    }

    public static void sendToClient(IPacket packet, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendToAllClients(IPacket packet) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    private static <T extends IPacket> void handlePacket(T packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        packet.handle(PacketsImpl.direction(context.getDirection()), (Player)context.getSender());
    }

    private static PacketDirection direction(NetworkDirection direction) {
        if (direction == NetworkDirection.PLAY_TO_SERVER) {
            return PacketDirection.TO_SERVER;
        }
        if (direction == NetworkDirection.PLAY_TO_CLIENT) {
            return PacketDirection.TO_CLIENT;
        }
        throw new IllegalStateException("Can only convert direction for Client/Server, not others.");
    }
}

