/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.gui.screen.widget;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class EnumButton<T extends Enum<T>>
extends ImageButton {
    private final OnStateChanged<T> onStateChanged;
    private final List<T> states;
    private final int xDiffTex;
    private int currentStateIndex;
    @Nullable
    private Function<T, Tooltip> tooltipFunc;
    @Nullable
    private Tooltip defaultTooltip;

    public EnumButton(Class<T> enumClass, int x, int y, int width, int height, int xTexStart, int yTexStart, int xDiffTex, int yDiffTex, ResourceLocation textureLocation, int textureWidth, int textureHeight, OnStateChanged<T> onStateChanged, Component message) {
        super(x, y, width, height, xTexStart, yTexStart, yDiffTex, textureLocation, textureWidth, textureHeight, b -> {}, message);
        this.onStateChanged = onStateChanged;
        this.states = Arrays.asList((Enum[])enumClass.getEnumConstants());
        this.currentStateIndex = 0;
        this.xDiffTex = xDiffTex;
    }

    public T getState() {
        return (T)((Enum)this.states.get(this.currentStateIndex));
    }

    public void setState(T state) {
        this.currentStateIndex = ((Enum)state).ordinal();
    }

    public void setStateIndex(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.states.size());
        this.currentStateIndex = index;
    }

    public void previousState() {
        this.currentStateIndex = (this.currentStateIndex - 1 + this.states.size()) % this.states.size();
    }

    public void nextState() {
        this.currentStateIndex = (this.currentStateIndex + 1) % this.states.size();
    }

    public void setDefaultTooltip(@Nullable Tooltip tooltip) {
        this.defaultTooltip = tooltip;
    }

    public void setTooltipFunc(@Nullable Function<T, Tooltip> tooltipFunc) {
        this.tooltipFunc = tooltipFunc;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.m_198029_()) {
            this.m_257544_(this.tooltipFunc != null ? (Tooltip)this.tooltipFunc.apply(this.getState()) : this.defaultTooltip);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_280322_(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int uOffset, int vOffset, int yDiffTex, int width, int height, int textureWidth, int textureHeight) {
        int xTex = uOffset + this.xDiffTex * this.currentStateIndex;
        int yTex = vOffset;
        if (!this.m_142518_()) {
            yTex = vOffset + yDiffTex * 2;
        } else if (this.m_198029_()) {
            yTex = vOffset + yDiffTex;
        }
        RenderSystem.enableDepthTest();
        guiGraphics.m_280163_(texture, x, y, (float)xTex, (float)yTex, width, height, textureWidth, textureHeight);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_142518_() && this.m_93680_(mouseX, mouseY)) {
            int prevIndex = this.currentStateIndex;
            if (button == 1) {
                this.previousState();
            } else {
                this.nextState();
            }
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.onStateChanged.onStateChanged((Button)this, (Enum)this.states.get(prevIndex), (Enum)this.states.get(this.currentStateIndex));
            this.m_5716_(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.m_142518_() && this.m_93680_(mouseX, mouseY)) {
            int prevIndex = this.currentStateIndex;
            if (delta < 0.0) {
                this.previousState();
            } else {
                this.nextState();
            }
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.onStateChanged.onStateChanged((Button)this, (Enum)this.states.get(prevIndex), (Enum)this.states.get(this.currentStateIndex));
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_142518_() && CommonInputs.m_278691_((int)keyCode)) {
            int prevIndex = this.currentStateIndex;
            if (Screen.m_96638_()) {
                this.previousState();
            } else {
                this.nextState();
            }
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.onStateChanged.onStateChanged((Button)this, (Enum)this.states.get(prevIndex), (Enum)this.states.get(this.currentStateIndex));
            this.m_5691_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public static interface OnStateChanged<T extends Enum<T>> {
        public void onStateChanged(Button var1, T var2, T var3);
    }
}

