/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.data.server;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure_catalog.data.ExposureInfo;
import io.github.mortuusars.exposure_catalog.data.ExposureThumbnail;
import io.github.mortuusars.exposure_catalog.mixin.ServersideExposureStorageAccessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CatalogCache {
    protected Logger LOGGER = LogUtils.getLogger();
    protected File exposuresFolder;
    protected AtomicBoolean isBuilding = new AtomicBoolean(false);
    protected ConcurrentMap<String, ExposureInfo> exposures = new ConcurrentHashMap<String, ExposureInfo>();
    protected ConcurrentMap<String, ExposureThumbnail> thumbnails = new ConcurrentHashMap<String, ExposureThumbnail>();
    protected List<Runnable> callbacks = Collections.synchronizedList(new ArrayList());

    public Map<String, ExposureInfo> getExposures() {
        return this.exposures;
    }

    public Map<String, ExposureThumbnail> getThumbnails() {
        return this.thumbnails;
    }

    public boolean isCurrentlyBuilding() {
        return this.isBuilding.get();
    }

    public synchronized void buildIfNeeded(Runnable onFinished) {
        if (!this.exposures.isEmpty() && !this.isCurrentlyBuilding()) {
            onFinished.run();
            return;
        }
        this.callbacks.add(onFinished);
        if (!this.isCurrentlyBuilding()) {
            new Thread(this::rebuildCache).start();
        }
    }

    public synchronized void rebuild(Runnable onFinished) {
        this.callbacks.add(onFinished);
        this.exposures.clear();
        this.thumbnails.clear();
        this.rebuildCache();
    }

    public void addExposure(String exposureId, ExposureSavedData data) {
        ExposureInfo exposureData = this.createExposureData(exposureId, data);
        this.exposures.put(exposureId, exposureData);
        ExposureThumbnail thumbnail = this.createThumbnail(exposureId, data, this.getThumbnailSize());
        this.thumbnails.put(exposureId, thumbnail);
    }

    public void removeExposure(String exposureId) {
        this.exposures.remove(exposureId);
        this.thumbnails.remove(exposureId);
    }

    public void clear() {
        this.exposures.clear();
        this.thumbnails.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void rebuildCache() {
        block13: {
            this.isBuilding.set(true);
            try {
                DimensionDataStorage dataStorage = ((ServersideExposureStorageAccessor)ExposureServer.getExposureStorage()).getLevelStorageSupplier().get();
                dataStorage.m_78151_();
                this.clear();
                this.exposuresFolder = ((ServersideExposureStorageAccessor)ExposureServer.getExposureStorage()).getWorldPathSupplier().get().resolve("data/exposures/").toFile();
                this.LOGGER.info("Building exposures cache...");
                List exposureIds = ExposureServer.getExposureStorage().getAllIds();
                if (exposureIds.isEmpty()) {
                    this.LOGGER.info("No exposures have been found.");
                    return;
                }
                this.LOGGER.info("Loading {} exposures...", (Object)exposureIds.size());
                long start = Util.m_137550_();
                List chunks = Lists.partition((List)exposureIds, (int)600);
                ArrayList<Thread> threads = new ArrayList<Thread>();
                for (List chunk : chunks) {
                    Thread thread = new Thread(() -> this.processExposures(chunk));
                    threads.add(thread);
                    thread.start();
                }
                for (Thread thread : threads) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        this.LOGGER.error(e.toString());
                    }
                }
                this.LOGGER.info("{} exposures loaded in {}ms.", (Object)exposureIds.size(), (Object)(Util.m_137550_() - start));
                this.isBuilding.set(false);
            }
            catch (Exception e) {
                this.LOGGER.error("Error occurred when building exposures cache: {}", (Object)e.toString());
                break block13;
            }
            finally {
                this.isBuilding.set(false);
                for (Runnable callback : this.callbacks) {
                    callback.run();
                }
                this.callbacks.clear();
            }
            for (Runnable callback : this.callbacks) {
                callback.run();
            }
            this.callbacks.clear();
        }
    }

    protected void processExposures(List<String> exposureIds) {
        DimensionDataStorage dataStorage = ((ServersideExposureStorageAccessor)ExposureServer.getExposureStorage()).getLevelStorageSupplier().get();
        for (String exposureId : exposureIds) {
            @Nullable ExposureSavedData savedData = this.loadExposure(exposureId, dataStorage);
            ExposureInfo exposureData = this.createExposureData(exposureId, savedData);
            this.exposures.put(exposureId, exposureData);
            ExposureThumbnail thumbnail = this.createThumbnail(exposureId, savedData, this.getThumbnailSize());
            this.thumbnails.put(exposureId, thumbnail);
        }
    }

    protected int getThumbnailSize() {
        return 54;
    }

    @Nullable
    protected ExposureSavedData loadExposure(String exposureId, DimensionDataStorage storage) {
        try {
            File exposureFile = this.getDataFile(exposureId);
            if (!exposureFile.exists()) {
                this.LOGGER.error("Cannot load exposure '{}': File {} does not exist.", (Object)exposureId, (Object)exposureFile);
                return null;
            }
            CompoundTag exposureTag = storage.m_78158_("exposures/" + exposureId, SharedConstants.m_183709_().m_183476_().m_193006_()).m_128469_("data");
            return ExposureSavedData.load((CompoundTag)exposureTag);
        }
        catch (Exception e) {
            this.LOGGER.error("Cannot load exposure '{}': {}", (Object)exposureId, (Object)e);
            return null;
        }
    }

    protected File getDataFile(String name) {
        return new File(this.exposuresFolder, name + ".dat");
    }

    protected ExposureThumbnail createThumbnail(String exposureId, @Nullable ExposureSavedData exposure, int size) {
        if (exposure == null) {
            return new ExposureThumbnail(exposureId, 1, 1, new byte[]{0});
        }
        float scaleFactorX = (float)size / (float)exposure.getWidth();
        float scaleFactorY = (float)size / (float)exposure.getHeight();
        byte[] pixels = new byte[size * size];
        for (int y = 0; y < size; ++y) {
            int yIndex = (int)((float)y / scaleFactorY);
            for (int x = 0; x < size; ++x) {
                byte pixel;
                int xIndex = (int)((float)x / scaleFactorX);
                pixels[y * size + x] = pixel = exposure.getPixel(xIndex, yIndex);
            }
        }
        return new ExposureThumbnail(exposureId, size, size, pixels);
    }

    protected ExposureInfo createExposureData(String exposureId, @Nullable ExposureSavedData savedData) {
        if (savedData == null) {
            return ExposureInfo.empty(exposureId);
        }
        return new ExposureInfo(exposureId, savedData.getWidth(), savedData.getHeight(), savedData.getType(), savedData.getProperties().m_128471_("WasPrinted"), savedData.getProperties().m_128471_("FromFile"), savedData.getProperties().m_128454_("Timestamp"));
    }
}

