/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import java.io.IOException;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;

public class TextureUtility {
    public void generateSpecialLog(ResourceLocation baseTextureLoc, ResourceLocation logMaskLoc, ResourceLocation planksMaskLoc, String shortenedId, String prefixOrEmpty, String suffix, SimpleEntrySet<WoodType, Block> mainBlock, ResourceSink sink, ResourceManager manager) {
        try (TextureImage mainTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)baseTextureLoc);
             TextureImage innerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)logMaskLoc);
             TextureImage outerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)planksMaskLoc);){
            Respriter innerResprite = Respriter.masked((TextureImage)mainTexture, (TextureImage)innerMask);
            mainBlock.blocks.forEach((woodType, block) -> {
                try (TextureImage planksTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)woodType.getBlockOfThis("planks")));
                     TextureImage logSideTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)woodType.getBlockOfThis("log"), CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));){
                    String newPath = woodType.createFullIdWith("", "block", shortenedId, prefixOrEmpty, "filename");
                    sink.addTextureIfNotPresent(manager, newPath, () -> {
                        try (TextureImage recoloredInner = innerResprite.recolorWithAnimationOf(planksTexture);){
                            Respriter outerResprite = Respriter.masked((TextureImage)recoloredInner, (TextureImage)outerMask);
                            TextureImage textureImage = outerResprite.recolorWithAnimationOf(logSideTexture);
                            return textureImage;
                        }
                    });
                }
                catch (IOException e) {
                    EveryCompat.LOGGER.error("Failed to generate planked_log texture for {} : {}", (Object)woodType.getId(), (Object)String.valueOf(e));
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to get textures for planked_logs: {}", (Object)String.valueOf(e));
        }
    }
}

