/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.leveling;

import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketRelicTweak {
    private final int container;
    private final int slot;
    private final String ability;
    private final Operation operation;

    public PacketRelicTweak(FriendlyByteBuf buf) {
        this.container = buf.readInt();
        this.slot = buf.readInt();
        this.ability = buf.m_130277_();
        this.operation = (Operation)buf.m_130066_(Operation.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.container);
        buf.writeInt(this.slot);
        buf.m_130070_(this.ability);
        buf.m_130068_((Enum)this.operation);
    }

    private static void causeError(Player player) {
        player.m_5661_((Component)Component.m_237115_((String)"info.relics.researching.wrong_container").m_130940_(ChatFormatting.RED), false);
        player.m_6915_();
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                PacketRelicTweak.causeError((Player)player);
                return;
            }
            if (player.f_36096_.f_38840_ != this.container) {
                PacketRelicTweak.causeError((Player)player);
                return;
            }
            ItemStack stack = DescriptionUtils.gatherRelicStack((Player)player, this.slot);
            Item patt0$temp = stack.m_41720_();
            if (!(patt0$temp instanceof IRelicItem)) {
                PacketRelicTweak.causeError((Player)player);
                return;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            AbilityData entry = relic.getAbilityData(this.ability);
            if (entry == null) {
                return;
            }
            switch (this.operation.ordinal()) {
                case 1: {
                    if (!relic.mayPlayerUpgrade((Player)player, stack, this.ability)) break;
                    player.m_6756_(-relic.getUpgradeRequiredExperience(stack, this.ability));
                    relic.setAbilityPoints(stack, this.ability, relic.getAbilityPoints(stack, this.ability) + 1);
                    relic.addPoints(stack, -entry.getRequiredPoints());
                    break;
                }
                case 2: {
                    if (!relic.mayPlayerReroll((Player)player, stack, this.ability)) break;
                    player.m_6756_(-relic.getRerollRequiredExperience(this.ability));
                    relic.randomizeStats(stack, this.ability);
                    break;
                }
                case 0: {
                    if (!relic.mayPlayerReset((Player)player, stack, this.ability)) break;
                    player.m_6756_(-relic.getResetRequiredExperience(stack, this.ability));
                    relic.addPoints(stack, relic.getAbilityPoints(stack, this.ability) * entry.getRequiredPoints());
                    relic.setAbilityPoints(stack, this.ability, 0);
                }
            }
            try {
                player.f_36096_.m_38853_(this.slot).m_5852_(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                PacketRelicTweak.causeError((Player)player);
            }
        });
        return true;
    }

    public PacketRelicTweak(int container, int slot, String ability, Operation operation) {
        this.container = container;
        this.slot = slot;
        this.ability = ability;
        this.operation = operation;
    }

    public static enum Operation {
        RESET(0),
        UPGRADE(1),
        REROLL(2);

        public static final IntFunction<Operation> BY_ID;
        private final int id;

        public int getId() {
            return this.id;
        }

        private Operation(int id) {
            this.id = id;
        }

        static {
            BY_ID = ByIdMap.m_262839_(Operation::getId, (Object[])Operation.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

