/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.abilities;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.system.casts.abilities.AbilityReference;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SpellCastPacket {
    private final CastType type;
    private final CastStage stage;
    private final CompoundTag ability;

    public SpellCastPacket(FriendlyByteBuf buf) {
        this.type = (CastType)buf.m_130066_(CastType.class);
        this.stage = (CastStage)buf.m_130066_(CastStage.class);
        this.ability = buf.m_130260_();
    }

    public SpellCastPacket(CastType type, CastStage stage, CompoundTag ability) {
        this.type = type;
        this.stage = stage;
        this.ability = ability;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.m_130068_((Enum)this.stage);
        buf.m_130079_(this.ability);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            AbilityReference reference = new AbilityReference().deserializeNBT(this.ability);
            ItemStack stack = reference.getSlot().gatherStack((Player)player);
            Item patt0$temp = stack.m_41720_();
            if (!(patt0$temp instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            if (!relic.canPlayerUseActiveAbility((Player)player, stack, reference.getId())) {
                if (relic.isAbilityTicking(stack, reference.getId())) {
                    relic.setAbilityTicking(stack, reference.getId(), false);
                    relic.castActiveAbility(stack, (Player)player, reference.getId(), this.type, CastStage.END);
                }
                return;
            }
            block0 : switch (this.type) {
                case CYCLICAL: 
                case TOGGLEABLE: {
                    switch (this.stage) {
                        case START: {
                            relic.setAbilityTicking(stack, reference.getId(), true);
                            break block0;
                        }
                        case END: {
                            relic.setAbilityTicking(stack, reference.getId(), false);
                        }
                    }
                }
            }
            relic.castActiveAbility(stack, (Player)player, reference.getId(), this.type, this.stage);
        });
        return true;
    }
}

