/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.entities.SporeModel;
import it.hurts.sskirillss.relics.entities.SporeEntity;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SporeRenderer
extends EntityRenderer<SporeEntity> {
    public SporeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(SporeEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ItemStack stack;
        Item item;
        float time = (float)entityIn.f_19797_ + (Minecraft.m_91087_().m_91104_() ? 0.0f : partialTicks);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, Math.pow(Math.log10(1.0f + entityIn.getSize()), 0.3333333333333333) / 4.0, 0.0);
        if (!entityIn.isStuck()) {
            float speed = 15.0f;
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(time * speed));
            matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(time * speed));
        }
        if ((item = (stack = entityIn.getStack()).m_41720_()) instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            double inlinedSize = Math.pow(Math.log10(1.0f + entityIn.getSize()), 0.3333333333333333);
            int maxLifetime = (int)Math.round(relic.getAbilityValue(entityIn.getStack(), "spore", "duration") * 20.0);
            int lifetime = entityIn.getLifetime();
            float scale = (float)(inlinedSize + Math.abs(Math.sin(((float)entityIn.f_19797_ + (Minecraft.m_91087_().m_91104_() ? 0.0f : partialTicks)) * 0.2f)) * (double)0.05f + (double)(lifetime >= maxLifetime - 20 ? (float)((double)((float)(20 - (maxLifetime - lifetime)) + (Minecraft.m_91087_().m_91104_() ? 0.0f : partialTicks)) * (inlinedSize * (double)0.035f)) : 0.0f));
            matrixStackIn.m_85841_(scale, scale, scale);
        }
        new SporeModel().m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("relics", "textures/entities/spore.png"))), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(SporeEntity entity) {
        return new ResourceLocation("relics", "textures/entities/spore.png");
    }
}

