/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.item;

import com.hrznstudio.titanium.api.augment.IAugmentType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class AugmentWrapper {
    public static HashMap<Integer, AugmentCache> STACK_AUGMENT_CACHE = new LinkedHashMap<Integer, AugmentCache>();
    public static final String AUGMENT_NBT = "TitaniumAugment";

    public static boolean isAugment(ItemStack augment) {
        if (!augment.m_41619_()) {
            int hash = augment.hashCode();
            if (STACK_AUGMENT_CACHE.containsKey(hash)) {
                return true;
            }
            if (augment.m_41782_() && augment.m_41783_().m_128441_(AUGMENT_NBT)) {
                STACK_AUGMENT_CACHE.put(hash, new AugmentCache(augment));
                return true;
            }
        }
        return false;
    }

    public static AugmentCache getAugment(ItemStack augment) {
        if (!augment.m_41619_()) {
            int hash = augment.hashCode();
            if (STACK_AUGMENT_CACHE.containsKey(hash)) {
                return STACK_AUGMENT_CACHE.get(hash);
            }
            if (augment.m_41782_() && augment.m_41783_().m_128441_(AUGMENT_NBT)) {
                AugmentCache augmentCache = new AugmentCache(augment);
                STACK_AUGMENT_CACHE.put(hash, augmentCache);
                return augmentCache;
            }
        }
        return null;
    }

    public static boolean hasType(ItemStack augment, IAugmentType type) {
        AugmentCache augmentCache = AugmentWrapper.getAugment(augment);
        return augmentCache != null && augmentCache.hasAugment(type);
    }

    public static float getType(ItemStack augment, IAugmentType type) {
        AugmentCache augmentCache = AugmentWrapper.getAugment(augment);
        return augmentCache != null ? augmentCache.getAugment(type) : 0.0f;
    }

    public static void setType(ItemStack augment, IAugmentType type, float amount) {
        CompoundTag nbt = augment.m_41784_();
        CompoundTag augmentNBT = nbt.m_128441_(AUGMENT_NBT) ? nbt.m_128469_(AUGMENT_NBT) : new CompoundTag();
        augmentNBT.m_128350_(type.getType(), amount);
        nbt.m_128365_(AUGMENT_NBT, (Tag)augmentNBT);
        augment.m_41751_(nbt);
    }

    private static class AugmentCache {
        private HashMap<String, Float> augmentValues = new LinkedHashMap<String, Float>();

        public AugmentCache(ItemStack stack) {
            CompoundTag compound = stack.m_41783_().m_128469_(AugmentWrapper.AUGMENT_NBT);
            for (String allKey : compound.m_128431_()) {
                this.augmentValues.put(allKey, Float.valueOf(compound.m_128457_(allKey)));
            }
        }

        public boolean hasAugment(IAugmentType type) {
            return this.augmentValues.containsKey(type.getType());
        }

        public float getAugment(IAugmentType type) {
            return this.augmentValues.get(type.getType()).floatValue();
        }
    }
}

