/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.DirectionalImage;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.graphics.Renderer;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Sprite;
import net.tejty.gamediscs.games.util.VecUtil;

public class FroggieGame
extends Game {
    private Sprite frog = new Sprite(new Vec2(0.0f, 0.0f), new Vec2(7.0f, 7.0f), new DirectionalImage(new ResourceLocation("gamediscs", "textures/games/sprite/frog.png"), 7, 28));
    private int moveCooldown = 0;
    private List<Sprite> minecarts = new ArrayList<Sprite>();
    private List<Sprite> logs = new ArrayList<Sprite>();
    private static final int TILE_SIZE = 7;
    private List<Integer> holes = List.of(Integer.valueOf(2), Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(14), Integer.valueOf(18));
    private List<Boolean> isHoleFull = new ArrayList<Boolean>();
    private int lastLine = 0;

    private static Vec2 getPos(Vec2 tile) {
        return tile.m_165903_(7.0f);
    }

    private static Vec2 getTile(Vec2 pos) {
        return VecUtil.round(pos.m_165903_(0.14285715f));
    }

    public FroggieGame() {
        for (int i = 0; i < 5; ++i) {
            this.isHoleFull.add(false);
        }
    }

    @Override
    public synchronized void prepare() {
        this.isHoleFull = new ArrayList<Boolean>();
        for (int i = 0; i < 5; ++i) {
            this.isHoleFull.add(false);
        }
        super.prepare();
        this.minecarts.clear();
        this.logs.clear();
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(20.0f, 12.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(19.0f, 12.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(18.0f, 12.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(12.0f, 12.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(11.0f, 12.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(0.0f, 11.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(10.0f, 11.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(15.0f, 10.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-4.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(16.0f, 10.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-4.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(5.0f, 10.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-4.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(6.0f, 10.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-4.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(13.0f, 9.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(6.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(8.0f, 8.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(9.0f, 8.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(10.0f, 8.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(16.0f, 8.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(17.0f, 8.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.minecarts.add(new Sprite(FroggieGame.getPos(new Vec2(18.0f, 8.0f)), new Vec2(7.0f, 7.0f), new ResourceLocation("gamediscs", "textures/games/sprite/minecart.png")).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(1.0f, 5.0f)), new Vec2(21.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/log.png"), 63, 7, 0, 0, 21, 7)).addVelocity(new Vec2(1.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(5.0f, 5.0f)), new Vec2(21.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/log.png"), 63, 7, 0, 0, 21, 7)).addVelocity(new Vec2(1.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(16.0f, 5.0f)), new Vec2(21.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/log.png"), 63, 7, 0, 0, 21, 7)).addVelocity(new Vec2(1.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(1.0f, 6.0f)), new Vec2(14.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/turtles.png"), 28, 7, 0, 0, 14, 7)).addVelocity(new Vec2(-1.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(4.0f, 6.0f)), new Vec2(14.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/turtles.png"), 28, 7, 0, 0, 14, 7)).addVelocity(new Vec2(-1.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(9.0f, 6.0f)), new Vec2(14.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/turtles.png"), 28, 7, 0, 0, 14, 7)).addVelocity(new Vec2(-1.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(15.0f, 6.0f)), new Vec2(14.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/turtles.png"), 28, 7, 0, 0, 14, 7)).addVelocity(new Vec2(-1.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(2.0f, 4.0f)), new Vec2(63.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/log.png"), 63, 7, 0, 0, 63, 7)).addVelocity(new Vec2(2.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(3.0f, 3.0f)), new Vec2(28.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/turtles.png"), 28, 7, 0, 0, 28, 7)).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(9.0f, 3.0f)), new Vec2(28.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/turtles.png"), 28, 7, 0, 0, 28, 7)).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(15.0f, 3.0f)), new Vec2(28.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/turtles.png"), 28, 7, 0, 0, 28, 7)).addVelocity(new Vec2(-2.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(1.0f, 2.0f)), new Vec2(35.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/log.png"), 63, 7, 0, 0, 35, 7)).addVelocity(new Vec2(2.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(8.0f, 2.0f)), new Vec2(35.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/log.png"), 63, 7, 0, 0, 35, 7)).addVelocity(new Vec2(2.0f, 0.0f)));
        this.logs.add(new Sprite(FroggieGame.getPos(new Vec2(14.0f, 2.0f)), new Vec2(35.0f, 7.0f), new Image(new ResourceLocation("gamediscs", "textures/games/sprite/log.png"), 63, 7, 0, 0, 35, 7)).addVelocity(new Vec2(2.0f, 0.0f)));
    }

    @Override
    public synchronized void respawn() {
        super.respawn();
        this.frog.setPos(new Vec2(67.0f, 91.0f));
        this.frog.setImage(new DirectionalImage(new ResourceLocation("gamediscs", "textures/games/sprite/frog.png"), 7, 28));
        this.lastLine = (int)FroggieGame.getTile((Vec2)this.frog.getPos()).f_82471_;
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void tick() {
        super.tick();
    }

    @Override
    public synchronized void gameTick() {
        int i;
        super.gameTick();
        for (i = 0; i < this.minecarts.size(); ++i) {
            Sprite minecart = this.minecarts.get(i);
            int oldX = (int)minecart.getX();
            minecart.tick();
            int newX = (int)minecart.getX();
            if (oldX > 0 && newX <= 0) {
                this.minecarts.add(new Sprite(new Vec2(140.0f, minecart.getY()), minecart.getSize(), minecart.getImage()).addVelocity(minecart.getVelocity()));
            }
            if ((float)newX + minecart.getWidth() < 0.0f) {
                this.minecarts.remove(i);
                --i;
            }
            if ((float)oldX + minecart.getWidth() < 140.0f && (float)newX + minecart.getWidth() >= 140.0f) {
                this.minecarts.add(new Sprite(new Vec2(0.0f - minecart.getWidth(), minecart.getY()), minecart.getSize(), minecart.getImage()).addVelocity(minecart.getVelocity()));
            }
            if (newX > 140) {
                this.minecarts.remove(i);
                --i;
            }
            if (!minecart.isTouching(this.frog)) continue;
            this.lostLife();
        }
        Sprite logOn = null;
        for (i = 0; i < this.logs.size(); ++i) {
            Sprite log = this.logs.get(i);
            int oldX = (int)log.getX();
            log.tick();
            int newX = (int)log.getX();
            if (oldX > 0 && newX <= 0) {
                this.logs.add(new Sprite(new Vec2(140.0f, log.getY()), log.getSize(), log.getImage()).addVelocity(log.getVelocity()));
            }
            if ((float)newX + log.getWidth() < 0.0f) {
                this.logs.remove(i);
                --i;
            }
            if ((float)oldX + log.getWidth() < 140.0f && (float)newX + log.getWidth() >= 140.0f) {
                this.logs.add(new Sprite(new Vec2(0.0f - log.getWidth(), log.getY()), log.getSize(), log.getImage()).addVelocity(log.getVelocity()));
            }
            if (newX > 140) {
                this.logs.remove(i);
                --i;
            }
            Vec2 frogPos = this.frog.getCenterPos();
            if (!(frogPos.f_82470_ > log.getX()) || !(frogPos.f_82471_ > log.getY()) || !(frogPos.f_82470_ < log.getX() + log.getWidth()) || !(frogPos.f_82471_ < log.getY() + log.getHeight())) continue;
            logOn = log;
        }
        int height = (int)FroggieGame.getTile((Vec2)this.frog.getPos()).f_82471_;
        if (height > 1 && height < 7 && logOn == null) {
            this.lostLife();
        } else if (logOn != null) {
            this.frog.moveBy(logOn.getVelocity());
        }
        Vec2 frogPos = this.frog.getCenterPos();
        if (frogPos.f_82470_ > 140.0f || frogPos.f_82470_ < 0.0f || frogPos.f_82471_ > 100.0f || frogPos.f_82471_ < 0.0f) {
            this.lostLife();
        }
        frogPos = FroggieGame.getTile(this.frog.getPos());
        if (frogPos.f_82471_ == 1.0f) {
            for (int j = 0; j < this.holes.size(); ++j) {
                int hole = this.holes.get(j);
                if (!(frogPos.f_82470_ > (float)(hole - 2)) || !(frogPos.f_82470_ < (float)(hole + 1))) continue;
                if (this.isHoleFull.get(j).booleanValue()) {
                    this.lostLife();
                    continue;
                }
                this.isHoleFull.set(j, true);
                this.score += 5;
                this.respawn();
                boolean flag = true;
                for (boolean checkHole : this.isHoleFull) {
                    if (checkHole) continue;
                    flag = false;
                }
                if (!flag) continue;
                this.score += 100;
                this.win();
            }
        }
        if (this.moveCooldown < 2) {
            ++this.moveCooldown;
        }
    }

    @Override
    public int gameTickDuration() {
        return 2;
    }

    @Override
    public synchronized void die() {
        super.die();
    }

    @Override
    public int maxLives() {
        return 5;
    }

    @Override
    public synchronized void render(GuiGraphics graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        for (Sprite minecart : this.minecarts) {
            minecart.render(graphics, posX, posY);
        }
        for (Sprite log : this.logs) {
            log.render(graphics, posX, posY);
        }
        this.frog.render(graphics, posX, posY);
        Vec2 frogPos = this.frog.getPos();
        int image = 0;
        Renderer renderer = this.frog.getImage();
        if (renderer instanceof DirectionalImage) {
            DirectionalImage direcional = (DirectionalImage)renderer;
            image = direcional.current();
        }
        for (int i = 0; i < this.holes.size(); ++i) {
            if (!this.isHoleFull.get(i).booleanValue()) continue;
            this.frog.setPos(FroggieGame.getPos(new Vec2((float)this.holes.get(i).intValue() - 0.5f, 1.0f)));
            Renderer renderer2 = this.frog.getImage();
            if (renderer2 instanceof DirectionalImage) {
                DirectionalImage direcional = (DirectionalImage)renderer2;
                direcional.setImage(2);
            }
            this.frog.render(graphics, posX, posY);
        }
        this.frog.setPos(frogPos);
        renderer = this.frog.getImage();
        if (renderer instanceof DirectionalImage) {
            DirectionalImage direcional = (DirectionalImage)renderer;
            direcional.setImage(image);
        }
        this.renderParticles(graphics, posX, posY);
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent mutableComponent = Component.m_237113_((String)String.valueOf(this.score));
        Objects.requireNonNull(font);
        graphics.m_280614_(font, (Component)mutableComponent, posX + 2, posY + 100 - 9, 0xFFFFFF, true);
        this.renderOverlay(graphics, posX, posY);
    }

    @Override
    public synchronized void buttonDown(Button button) {
        super.buttonDown(button);
        if (this.stage == GameStage.PLAYING && this.ticks > 5 && this.moveCooldown >= 2) {
            DirectionalImage image;
            Renderer renderer;
            if (button == Button.UP) {
                this.frog.moveBy(VecUtil.VEC_UP.m_165903_(7.0f));
                renderer = this.frog.getImage();
                if (renderer instanceof DirectionalImage) {
                    image = (DirectionalImage)renderer;
                    image.setImage(0);
                }
                if (FroggieGame.getTile((Vec2)this.frog.getPos()).f_82471_ < (float)this.lastLine) {
                    this.lastLine = (int)FroggieGame.getTile((Vec2)this.frog.getPos()).f_82471_;
                    ++this.score;
                }
                this.moveCooldown = 0;
                this.soundPlayer.playJump();
            }
            if (button == Button.RIGHT) {
                this.frog.moveBy(VecUtil.VEC_RIGHT.m_165903_(7.0f));
                renderer = this.frog.getImage();
                if (renderer instanceof DirectionalImage) {
                    image = (DirectionalImage)renderer;
                    image.setImage(1);
                }
                this.moveCooldown = 0;
                this.soundPlayer.playJump();
            }
            if (button == Button.DOWN) {
                this.frog.moveBy(VecUtil.VEC_DOWN.m_165903_(7.0f));
                renderer = this.frog.getImage();
                if (renderer instanceof DirectionalImage) {
                    image = (DirectionalImage)renderer;
                    image.setImage(2);
                }
                this.moveCooldown = 0;
                this.soundPlayer.playJump();
            }
            if (button == Button.LEFT) {
                this.frog.moveBy(VecUtil.VEC_LEFT.m_165903_(7.0f));
                renderer = this.frog.getImage();
                if (renderer instanceof DirectionalImage) {
                    image = (DirectionalImage)renderer;
                    image.setImage(3);
                }
                this.moveCooldown = 0;
                this.soundPlayer.playJump();
            }
        }
    }

    @Override
    public ResourceLocation getBackground() {
        return new ResourceLocation("gamediscs", "textures/games/background/froggie_background.png");
    }

    @Override
    public boolean showScore() {
        return false;
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"gamediscs.froggie");
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("gamediscs", "textures/item/game_disc_froggie.png");
    }
}

