/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.client;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.tejty.gamediscs.client.screen.GamingConsoleScreen;
import net.tejty.gamediscs.games.gamediscs.BlocktrisGame;
import net.tejty.gamediscs.games.gamediscs.FlappyBirdGame;
import net.tejty.gamediscs.games.gamediscs.FroggieGame;
import net.tejty.gamediscs.games.gamediscs.PongGame;
import net.tejty.gamediscs.games.gamediscs.RabbitGame;
import net.tejty.gamediscs.games.gamediscs.SlimeGame;
import net.tejty.gamediscs.games.gamediscs.TntSweeperGame;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.item.ItemRegistry;
import net.tejty.gamediscs.item.custom.GameDiscItem;

public class ClientUtils {
    private static final Map<Item, Supplier<Game>> GAMES = new IdentityHashMap<Item, Supplier<Game>>();

    public static void openConsoleScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new GamingConsoleScreen((Component)Component.m_237115_((String)"gui.gamingconsole.title")));
    }

    private static void registerGames() {
        GAMES.put((Item)ItemRegistry.GAME_DISC_FLAPPY_BIRD.get(), FlappyBirdGame::new);
        GAMES.put((Item)ItemRegistry.GAME_DISC_SLIME.get(), SlimeGame::new);
        GAMES.put((Item)ItemRegistry.GAME_DISC_BLOCKTRIS.get(), BlocktrisGame::new);
        GAMES.put((Item)ItemRegistry.GAME_DISC_TNT_SWEEPER.get(), TntSweeperGame::new);
        GAMES.put((Item)ItemRegistry.GAME_DISC_PONG.get(), PongGame::new);
        GAMES.put((Item)ItemRegistry.GAME_DISC_FROGGIE.get(), FroggieGame::new);
        GAMES.put((Item)ItemRegistry.GAME_DISC_RABBIT.get(), RabbitGame::new);
    }

    public static Game newGameFor(GameDiscItem item) {
        Supplier<Game> sup;
        if (GAMES.isEmpty()) {
            ClientUtils.registerGames();
        }
        if ((sup = GAMES.get((Object)item)) == null) {
            throw new IllegalArgumentException("No game specified for " + item + " (" + BuiltInRegistries.f_257033_.m_7981_((Object)item) + ")");
        }
        return sup.get();
    }
}

