/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class SlimeBreedRegistration {
    public static JsonObject getEffectJson(Object effect, boolean isInfinite) {
        JsonObject jsonEffect = new JsonObject();
        if (effect.getClass() == MobEffectInstance.class) {
            jsonEffect.addProperty("effect", BuiltInRegistries.f_256974_.m_7981_((Object)((MobEffectInstance)effect).m_19544_()).toString());
            if (!isInfinite) {
                jsonEffect.addProperty("duration", (Number)((MobEffectInstance)effect).m_19557_());
            }
            jsonEffect.addProperty("amplifier", (Number)((MobEffectInstance)effect).m_19564_());
        }
        return jsonEffect;
    }

    public static MobEffectInstance getEffectFromJson(JsonElement jsonElement, boolean isInfinite) {
        MobEffect postiveEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("minecraft:slowness"));
        int duration = isInfinite ? -1 : 40;
        int amplifier = 0;
        if (jsonElement.getAsJsonObject().has("effect")) {
            postiveEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(jsonElement.getAsJsonObject().get("effect").getAsString()));
        }
        if (!isInfinite && jsonElement.getAsJsonObject().has("duration")) {
            duration = jsonElement.getAsJsonObject().get("duration").getAsInt();
        }
        if (jsonElement.getAsJsonObject().has("amplifier")) {
            amplifier = jsonElement.getAsJsonObject().get("amplifier").getAsInt();
        }
        return new MobEffectInstance(postiveEffect, duration, amplifier, isInfinite, true);
    }

    public static String getParticleTypeJson(SimpleParticleType particleType) {
        return ForgeRegistries.PARTICLE_TYPES.getKey((Object)particleType).toString();
    }

    public static SimpleParticleType getParticleTypeFromJson(JsonElement jsonElement) {
        return (SimpleParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(jsonElement.getAsString()));
    }
}

