/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.item;

import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import io.github.chakyl.splendidslimes.data.SlimeBreed;
import io.github.chakyl.splendidslimes.data.SlimeBreedRegistry;
import io.github.chakyl.splendidslimes.entity.SlimeEntityBase;
import io.github.chakyl.splendidslimes.entity.SplendidSlime;
import io.github.chakyl.splendidslimes.registry.ModElements;
import io.github.chakyl.splendidslimes.util.SlimeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SlimeInventoryItem
extends Item
implements ITabFiller {
    public static final String SLIME = "slime";
    public static final String ID = "id";
    public static final String DATA = "data";

    public SlimeInventoryItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> list, TooltipFlag pFlag) {
        MutableComponent slimeDiet;
        DynamicHolder<SlimeBreed> slime = SlimeData.getSlimeData(pStack, SLIME);
        List<Object> traits = new ArrayList();
        if (!slime.isBound()) {
            slimeDiet = Component.m_237115_((String)"diet.splendid_slimes.default_diet");
        } else {
            slimeDiet = ((SlimeBreed)slime.get()).diet();
            traits = ((SlimeBreed)slime.get()).traits();
        }
        if (!traits.isEmpty()) {
            if (Screen.m_96638_()) {
                for (String trait : traits) {
                    list.add((Component)Component.m_237115_((String)("trait.splendid_slimes." + trait + ".name")).m_130940_(ChatFormatting.GRAY));
                    list.add((Component)Component.m_237115_((String)("trait.splendid_slimes." + trait + ".info")).m_130940_(ChatFormatting.DARK_GRAY));
                }
            } else {
                list.add((Component)Component.m_237110_((String)"entity.splendid_slimes.diet", (Object[])new Object[]{slimeDiet}).m_130940_(ChatFormatting.GRAY));
                list.add((Component)Component.m_237115_((String)"item.splendid_slimes.slime_item.tooltip_prompt"));
            }
        } else {
            list.add((Component)Component.m_237110_((String)"entity.splendid_slimes.diet", (Object[])new Object[]{slimeDiet}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void fillItemCategory(CreativeModeTab tab, CreativeModeTab.Output output) {
        SlimeBreedRegistry.INSTANCE.getKeys().stream().sorted().forEach(key -> {
            ItemStack s = new ItemStack((ItemLike)this);
            SlimeInventoryItem.setStoredSlime(s, key);
            output.m_246342_(s);
        });
    }

    public Component m_7626_(ItemStack pStack) {
        DynamicHolder<SlimeBreed> slime = SlimeData.getSlimeData(pStack, SLIME);
        MutableComponent slimeName = !slime.isBound() ? Component.m_237115_((String)"item.splendid_slimes.default_slime_item") : ((SlimeBreed)slime.get()).name();
        return Component.m_237110_((String)this.m_5671_(pStack), (Object[])new Object[]{slimeName});
    }

    public static void setStoredSlime(ItemStack stack, SlimeBreed slimeBreed) {
        SlimeInventoryItem.setStoredSlime(stack, SlimeBreedRegistry.INSTANCE.getKey(slimeBreed));
    }

    public static void setStoredSlime(ItemStack stack, ResourceLocation plort) {
        stack.m_41749_(SLIME);
        stack.m_41698_(SLIME).m_128359_(ID, plort.toString());
    }

    public static SplendidSlime getSlimeFromItem(CompoundTag data, CompoundTag slimeData, Level level) {
        if (!slimeData.m_128456_() || !data.m_128456_()) {
            SplendidSlime slimeEntity = new SplendidSlime((EntityType<SlimeEntityBase>)((EntityType)ModElements.Entities.SPLENDID_SLIME.get()), level);
            if (!data.m_128456_()) {
                slimeEntity.m_20258_(data);
            } else {
                slimeEntity.setSlimeBreed(slimeData.m_128461_(ID));
            }
            return slimeEntity;
        }
        return null;
    }

    public static int getData(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(SLIME);
        return stack.m_41619_() || tag == null ? 0 : tag.m_128451_(DATA);
    }

    public static void setData(ItemStack stack, int data) {
        stack.m_41698_(SLIME).m_128405_(DATA, data);
    }
}

