/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.item.ItemProjectile;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemProjectileType {
    private List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    private float drag = 0.99f;
    private float velocityMultiplier = 1.0f;
    private float gravityMultiplier = 1.0f;
    private Predicate<EntityHitResult> preEntityHit = e -> false;
    private Predicate<EntityHitResult> onEntityHit = e -> false;
    private BiPredicate<LevelAccessor, BlockHitResult> onBlockHit = (w, ray) -> false;

    protected ItemProjectileType() {
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public float getDrag() {
        return this.drag;
    }

    public float getVelocityMultiplier() {
        return this.velocityMultiplier;
    }

    public float getGravityMultiplier() {
        return this.gravityMultiplier;
    }

    public boolean preEntityHit(EntityHitResult ray) {
        return this.preEntityHit.test(ray);
    }

    public boolean onEntityHit(EntityHitResult ray) {
        return this.onEntityHit.test(ray);
    }

    public boolean onBlockHit(LevelAccessor world, BlockHitResult ray) {
        return this.onBlockHit.test(world, ray);
    }

    public static class Builder {
        protected ResourceLocation id;
        protected ItemProjectileType result;

        public Builder(ResourceLocation id) {
            this.id = id;
            this.result = new ItemProjectileType();
        }

        public Builder drag(float drag) {
            this.result.drag = drag;
            return this;
        }

        public Builder velocity(float velocity) {
            this.result.velocityMultiplier = velocity;
            return this;
        }

        public Builder gravity(float modifier) {
            this.result.gravityMultiplier = modifier;
            return this;
        }

        public Builder preEntityHit(Predicate<EntityHitResult> callback) {
            this.result.preEntityHit = callback;
            return this;
        }

        public Builder onEntityHit(Predicate<EntityHitResult> callback) {
            this.result.onEntityHit = callback;
            return this;
        }

        public Builder onBlockHit(BiPredicate<LevelAccessor, BlockHitResult> callback) {
            this.result.onBlockHit = callback;
            return this;
        }

        public Builder addItems(ItemLike ... items) {
            for (ItemLike provider : items) {
                this.result.items.add((Supplier<Item>)ForgeRegistries.ITEMS.getDelegateOrThrow((Object)provider.m_5456_()));
            }
            return this;
        }

        public ItemProjectileType register() {
            return this.result;
        }

        public ItemProjectileType registerAndAssign(ItemLike ... items) {
            this.addItems(items);
            this.register();
            return this.result;
        }
    }
}

