/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.chakyl.splendidslimes.client.model.SlimeEntityModel;
import io.github.chakyl.splendidslimes.client.model.SlimeHandyLayer;
import io.github.chakyl.splendidslimes.client.model.SlimeHatLayer;
import io.github.chakyl.splendidslimes.entity.SlimeEntityBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public class SlimeEntityRenderer
extends MobRenderer<SlimeEntityBase, SlimeEntityModel<SlimeEntityBase>> {
    public static final ModelLayerLocation SPLENDID_SLIME_BASE = new ModelLayerLocation(new ResourceLocation("splendid_slimes", "main"), "main");
    public static final ModelLayerLocation HAT_LAYER = new ModelLayerLocation(new ResourceLocation("splendid_slimes", "main"), "main");
    private static Map<String, ResourceLocation> cache = new HashMap<String, ResourceLocation>();

    public SlimeEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new SlimeEntityModel(context.m_174023_(SPLENDID_SLIME_BASE)), 0.25f);
        this.m_115326_(new SlimeHatLayer(this));
        this.m_115326_(new SlimeHandyLayer(this, context.m_234598_()));
    }

    public void render(SlimeEntityBase slimeEntityBase, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        this.f_114477_ = 0.25f * (float)slimeEntityBase.m_33632_();
        super.m_7392_((Mob)slimeEntityBase, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected RenderType getRenderType(SlimeEntityBase p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation resourcelocation = this.getTextureLocation(p_230496_1_);
        if (p_230496_3_) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (p_230496_2_) {
            return RenderType.m_110473_((ResourceLocation)resourcelocation);
        }
        return p_230496_4_ ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    protected void scale(SlimeEntityBase slimeEntityBase, PoseStack poseStack, float partialTickTime) {
        poseStack.m_85841_(0.999f, 0.999f, 0.999f);
        poseStack.m_252880_(0.0f, 0.001f, 0.0f);
        float slimeSize = slimeEntityBase.m_33632_();
        float lerpy = Mth.m_14179_((float)partialTickTime, (float)slimeEntityBase.f_33585_, (float)slimeEntityBase.f_33584_) / (slimeSize * 0.5f + 1.0f);
        float cutter = 1.0f / (lerpy + 1.0f);
        poseStack.m_85841_(cutter * slimeSize, 1.0f / cutter * slimeSize, cutter * slimeSize);
    }

    public ResourceLocation getTextureLocation(SlimeEntityBase slimeEntityBase) {
        String path = slimeEntityBase.getSlimeBreed().replace(":", ":textures/entity/slime/") + ".png";
        if (!cache.containsKey(path)) {
            cache.put(path, new ResourceLocation(path));
        }
        return cache.get(path);
    }
}

