/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.chakyl.splendidslimes.client.model.SlimeEntityModel;
import io.github.chakyl.splendidslimes.entity.SlimeEntityBase;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class SlimeHandyLayer<T extends Entity>
extends RenderLayer<T, SlimeEntityModel<T>> {
    private final ItemInHandRenderer itemInHandRenderer;

    public SlimeHandyLayer(RenderLayerParent<T, SlimeEntityModel<T>> renderer, ItemInHandRenderer pItemInHandRenderer) {
        super(renderer);
        this.itemInHandRenderer = pItemInHandRenderer;
    }

    protected void scale(SlimeEntityBase slimeEntityBase, PoseStack poseStack, float partialTickTime) {
        poseStack.m_85841_(0.999f, 0.999f, 0.999f);
        poseStack.m_252880_(0.0f, 0.001f, 0.0f);
        float slimeSize = slimeEntityBase.m_33632_();
        float lerpy = Mth.m_14179_((float)partialTickTime, (float)slimeEntityBase.f_33585_, (float)slimeEntityBase.f_33584_) / ((slimeSize += 0.25f) * 0.5f + 1.0f);
        float cutter = 1.0f / (lerpy + 1.0f);
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(cutter * slimeSize, 1.0f / cutter * slimeSize, cutter * slimeSize);
    }

    public void m_6494_(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (pLivingEntity.m_6084_() && !pLivingEntity.m_20145_()) {
            ItemStack stack = null;
            Iterable handSlots = pLivingEntity.m_6167_();
            for (ItemStack handItem : handSlots) {
                if (handItem.m_41619_()) continue;
                stack = handItem;
            }
            if (stack == null || stack.m_41619_()) {
                return;
            }
            if (!stack.m_41619_()) {
                pPoseStack.m_85836_();
                pPoseStack.m_85837_(0.25, 1.0, -0.25);
                pPoseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                this.itemInHandRenderer.m_269530_((LivingEntity)pLivingEntity, stack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, pPoseStack, pBuffer, pPackedLight);
                pPoseStack.m_85849_();
            }
        }
    }
}

