/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.blockentity;

import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import io.github.chakyl.splendidslimes.SlimyConfig;
import io.github.chakyl.splendidslimes.block.SlimeSpawnerBlock;
import io.github.chakyl.splendidslimes.entity.SplendidSlime;
import io.github.chakyl.splendidslimes.registry.ModElements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SlimeSpawnerBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    private int SPAWNER_COOLDOWN = SlimyConfig.slimeSpawnerTime;
    private int ACTIVATION_RANGE = 14;
    private int MAX_NEARBY_ENTITIES = 6;
    protected String slimeType = "";
    private int slimeCount = 3;
    private int cooldown = 0;
    private int dispensedSlimes = 0;

    public SlimeSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModElements.BlockEntities.SLIME_SPAWNER.get(), pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (!this.slimeType.isEmpty()) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.cooldown == 0) {
                int nearbySlimes;
                BlockPos facingPos = pos.m_121945_((Direction)state.m_61143_((Property)DispenserBlock.f_52659_));
                if (level.m_46467_() % 4L == 0L && this.dispensedSlimes == 0 && !level.m_8055_(facingPos).m_280296_() && this.isNearPlayer(level, pos) && (nearbySlimes = level.m_45976_(SplendidSlime.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_82400_(6.0)).size()) < this.MAX_NEARBY_ENTITIES) {
                    BlockState newState = (BlockState)state.m_61124_((Property)SlimeSpawnerBlock.OPEN, (Comparable)Boolean.valueOf(true));
                    level.m_46597_(pos, newState);
                    this.m_6596_();
                }
                if (level.m_46467_() % 4L == 0L && ((Boolean)state.m_61143_((Property)SlimeSpawnerBlock.OPEN)).booleanValue()) {
                    Direction direction = (Direction)state.m_61143_((Property)SlimeSpawnerBlock.FACING);
                    double d0 = (double)facingPos.m_123341_() + 0.5;
                    double d1 = facingPos.m_123342_();
                    double d2 = (double)facingPos.m_123343_() + 0.5;
                    RandomSource randomsource = level.f_46441_;
                    double d3 = randomsource.m_216328_((double)direction.m_122429_(), 0.11485000000000001);
                    double d4 = randomsource.m_216328_((double)direction.m_122430_(), 0.11485000000000001);
                    double d5 = randomsource.m_216328_((double)direction.m_122431_(), 0.11485000000000001);
                    SplendidSlime spawnedSlime = (SplendidSlime)((EntityType)ModElements.Entities.SPLENDID_SLIME.get()).m_20615_(level);
                    spawnedSlime.setSlimeBreed(this.slimeType);
                    spawnedSlime.m_7839_(2, true);
                    spawnedSlime.setEatingCooldown(SplendidSlime.SLIME_STARVING_COOLDOWN / 2);
                    spawnedSlime.m_5997_(d3, d4, d5);
                    spawnedSlime.m_7678_(d0, d1, d2, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                    level.m_7967_((Entity)spawnedSlime);
                    ++this.dispensedSlimes;
                    spawnedSlime.m_5496_(SoundEvents.f_11752_, 1.0f, 1.2f);
                }
            }
            if (this.dispensedSlimes == this.slimeCount) {
                this.cooldown = this.SPAWNER_COOLDOWN;
                this.dispensedSlimes = 0;
                BlockState newState = (BlockState)state.m_61124_((Property)SlimeSpawnerBlock.OPEN, (Comparable)Boolean.valueOf(false));
                level.m_46597_(pos, newState);
                this.m_6596_();
            }
        } else {
            this.cooldown = 0;
        }
    }

    private boolean isNearPlayer(Level pLevel, BlockPos pPos) {
        return pLevel.m_45914_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, (double)this.ACTIVATION_RANGE);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("cooldown", this.cooldown);
        tag.m_128359_("slimeType", this.slimeType);
        tag.m_128405_("slimeCount", this.slimeCount);
        tag.m_128405_("dispensedSlimes", this.dispensedSlimes);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cooldown = tag.m_128451_("cooldown");
        this.slimeType = tag.m_128461_("slimeType");
        this.slimeCount = tag.m_128451_("slimeCount");
        this.dispensedSlimes = tag.m_128451_("dispensedSlimes");
    }

    public void setSlimeType(String type) {
        this.slimeType = type;
    }

    public String getSlimeType() {
        return this.slimeType;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int setSlimeCount(int count) {
        this.slimeCount = count;
        return this.slimeCount;
    }

    public int getSlimeCount() {
        return this.slimeCount;
    }
}

